/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.async.disruptor;

import com.jdon.async.disruptor.DisruptorFactory;
import com.jdon.async.disruptor.DisruptorParams;
import com.jdon.async.disruptor.DomainEventHandlerAdapter;
import com.jdon.async.disruptor.pool.DisruptorCommandPoolFactory;
import com.jdon.async.disruptor.pool.DomainCommandHandlerLast;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.container.pico.Startable;
import com.jdon.domain.message.DomainCommandDispatchHandler;
import com.jdon.domain.message.DomainEventHandler;
import com.jdon.domain.message.consumer.ModelConsumerMethodHolder;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.EventHandlerGroup;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisruptorForCommandFactory
implements Startable {
    public static final String module = DisruptorForCommandFactory.class.getName();
    protected final Map<String, TreeSet<DomainEventHandler>> handlesMap;
    private String RingBufferSize;
    private ContainerWrapper containerWrapper;
    private DisruptorCommandPoolFactory disruptorCommandPoolFactory;
    private DisruptorFactory disruptorFactory;

    public DisruptorForCommandFactory(DisruptorParams disruptorParams, ContainerCallback containerCallback, DisruptorCommandPoolFactory disruptorCommandPoolFactory, DisruptorFactory disruptorFactory) {
        this.RingBufferSize = disruptorParams.getRingBufferSize();
        this.containerWrapper = containerCallback.getContainerWrapper();
        this.handlesMap = new ConcurrentHashMap<String, TreeSet<DomainEventHandler>>();
        this.disruptorCommandPoolFactory = disruptorCommandPoolFactory;
        this.disruptorCommandPoolFactory.setDisruptorForCommandFactory(this);
        this.disruptorFactory = disruptorFactory;
    }

    public Disruptor getDisruptor(String topic) {
        return this.disruptorCommandPoolFactory.getDisruptor(topic);
    }

    public void releaseDisruptor(Object owner) {
    }

    private Disruptor createDw(String topic) {
        return this.disruptorFactory.createDw(topic);
    }

    private Disruptor createDisruptorWithEventHandler(String topic) {
        TreeSet<DomainEventHandler> handlers = this.handlesMap.get(topic);
        if (handlers == null) {
            handlers = this.getTreeSet();
            handlers = this.loadOnCommandConsumers(topic, handlers);
            this.handlesMap.put(topic, handlers);
        }
        if (handlers.isEmpty()) {
            return null;
        }
        Disruptor dw = this.createDw(topic);
        EventHandlerGroup eh = null;
        for (DomainEventHandler handler : handlers) {
            DomainEventHandlerAdapter dea = new DomainEventHandlerAdapter(handler);
            if (eh == null) {
                eh = dw.handleEventsWith(new EventHandler[]{dea});
                continue;
            }
            eh = eh.handleEventsWith(new EventHandler[]{dea});
        }
        if (eh != null) {
            eh.handleEventsWith(new EventHandler[]{new DomainCommandHandlerLast(this)});
        }
        return dw;
    }

    public Disruptor createDisruptor(String topic) {
        Disruptor disruptor = this.createDisruptorWithEventHandler(topic);
        if (disruptor != null) {
            disruptor.start();
        }
        return disruptor;
    }

    public boolean isContain(String topic) {
        return this.containerWrapper.lookup("MEHTOD_TOPIC_COMMAND" + topic) != null;
    }

    public ModelConsumerMethodHolder getModelConsumerMethodHolder(String topic) {
        return (ModelConsumerMethodHolder)this.containerWrapper.lookup("MEHTOD_TOPIC_COMMAND" + topic);
    }

    protected TreeSet<DomainEventHandler> loadOnCommandConsumers(String topic, TreeSet<DomainEventHandler> ehs) {
        ModelConsumerMethodHolder modelConsumerMethodHolder = this.getModelConsumerMethodHolder(topic);
        if (modelConsumerMethodHolder == null) {
            return ehs;
        }
        DomainCommandDispatchHandler domainCommandDispatchHandler = new DomainCommandDispatchHandler(modelConsumerMethodHolder);
        ehs.add(domainCommandDispatchHandler);
        return ehs;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.containerWrapper = null;
        this.handlesMap.clear();
        this.RingBufferSize = null;
    }

    public TreeSet<DomainEventHandler> getTreeSet() {
        return new TreeSet<DomainEventHandler>(new Comparator(){

            public int compare(Object num1, Object num2) {
                String inum2;
                String inum1 = num1.getClass().getName();
                if (inum1.compareTo(inum2 = num2.getClass().getName()) < 1) {
                    return -1;
                }
                return 1;
            }
        });
    }
}

