/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.annotation;

import com.jdon.container.ContainerWrapper;
import com.jdon.container.access.TargetMetaDefHolder;
import com.jdon.container.annotation.AnnotationHolder;
import com.jdon.container.annotation.ContainerLoaderAnnotation;
import com.jdon.container.builder.ContainerRegistry;
import com.jdon.container.builder.StartablecomponentsRegistry;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.util.Debug;

public class AnnotationContainerRegistry
extends ContainerRegistry {
    public static final String module = AnnotationContainerRegistry.class.getName();
    private ContainerLoaderAnnotation containerLoaderAnnotation;
    private AppContextWrapper context;

    public AnnotationContainerRegistry(AppContextWrapper context, ContainerWrapper containerWrapper, ContainerLoaderAnnotation containerLoaderAnnotation) {
        super(containerWrapper);
        this.containerLoaderAnnotation = containerLoaderAnnotation;
        this.context = context;
    }

    public void registerAnnotationComponents() throws Exception {
        Debug.logVerbose("[JdonFramework] <------ register all annotation components(@component('xxx')/@Interceptor)  ------> ", module);
        try {
            AnnotationHolder annotationHolder = this.containerLoaderAnnotation.loadAnnotationHolder(this.context, this.containerWrapper);
            for (String name : annotationHolder.getComponentNames()) {
                Class classz = annotationHolder.getComponentClass(name);
                this.containerWrapper.register(name, classz);
                StartablecomponentsRegistry scr = (StartablecomponentsRegistry)this.containerWrapper.lookup("startablecomponentsRegistry");
                scr.add(classz, name);
            }
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework] registerAnnotationComponents error:" + e, module);
            throw new Exception(e);
        }
    }

    public void copyTargetMetaDefHolder() {
        TargetMetaDefHolder targetMetaDefHoader = (TargetMetaDefHolder)this.containerWrapper.lookup("targetMetaDefHolder");
        AnnotationHolder annotationHolder = this.containerLoaderAnnotation.loadAnnotationHolder(this.context, this.containerWrapper);
        targetMetaDefHoader.add(annotationHolder.getTargetMetaDefHolder().loadMetaDefs());
    }

    public ContainerLoaderAnnotation getContainerLoaderAnnotation() {
        return this.containerLoaderAnnotation;
    }
}

