/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.annotation.type;

import com.jdon.container.annotation.AnnotationUtil;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.util.scanAnnotation.ScanAnnotationDB;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationScaner {
    private ScanAnnotationDB db;
    private FutureTask<ScanAnnotationDB> ft;

    public Map<String, Set<String>> getScannedAnnotations(AppContextWrapper context) {
        if (this.db != null) {
            return this.db.getAnnotationIndex();
        }
        try {
            this.db = this.ft.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return this.db.getAnnotationIndex();
    }

    public void startScan(final AppContextWrapper context) {
        this.ft = new FutureTask<ScanAnnotationDB>(new Callable<ScanAnnotationDB>(){

            @Override
            public ScanAnnotationDB call() throws Exception {
                ScanAnnotationDB db = new ScanAnnotationDB();
                URL[] urls = AnnotationUtil.scanAnnotation(context);
                try {
                    db.scanArchives(urls);
                }
                catch (Exception e) {
                    System.err.print("[JdonFramework] scanAnnotation error:" + e);
                }
                return db;
            }
        });
        this.ft.run();
    }
}

