/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.annotation.type;

import com.jdon.annotation.Component;
import com.jdon.annotation.Consumer;
import com.jdon.annotation.Service;
import com.jdon.annotation.model.OnEvent;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.annotation.AnnotationHolder;
import com.jdon.container.annotation.type.AnnotationScaner;
import com.jdon.container.annotation.type.Utils;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.domain.message.DomainEventHandler;
import com.jdon.domain.message.consumer.ConsumerMethodHolder;
import com.jdon.util.ClassUtil;
import com.jdon.util.Debug;
import com.jdon.util.UtilValidate;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerLoader {
    public static final String module = ConsumerLoader.class.getName();
    public static final String TOPICNAME = "CONSUMER_TOPIC";
    public static final String TOPICNAME2 = "MEHTOD_TOPIC";
    AnnotationScaner annotationScaner;

    public ConsumerLoader(AnnotationScaner annotationScaner) {
        this.annotationScaner = annotationScaner;
    }

    public void loadAnnotationConsumers(AnnotationHolder annotationHolder, AppContextWrapper context, ContainerWrapper containerWrapper) {
        Set<String> classes = this.annotationScaner.getScannedAnnotations(context).get(Consumer.class.getName());
        if (classes == null) {
            return;
        }
        Debug.logVerbose("[JdonFramework] found Annotation components size:" + classes.size(), module);
        for (String className : classes) {
            this.createAnnotationConsumerClass(className, annotationHolder, containerWrapper);
        }
    }

    public void createAnnotationConsumerClass(String className, AnnotationHolder annotationHolder, ContainerWrapper containerWrapper) {
        try {
            Class cclass = Utils.createClass(className);
            if (!DomainEventHandler.class.isAssignableFrom(cclass)) {
                Debug.logError("[JdonFramework] " + cclass.getName() + " that with @Consumer annotataion must also implements  com.jdon.domain.message.DomainEventHandler ", module);
                return;
            }
            Consumer consumer = cclass.getAnnotation(Consumer.class);
            Debug.logVerbose("[JdonFramework] load Annotation Consumer name:" + cclass.getName() + " class:" + className, module);
            String topicname = UtilValidate.isEmpty(consumer.value()) ? cclass.getName() : consumer.value();
            String topicKey = TOPICNAME + topicname;
            Collection<String> consumers = this.getContainerConsumers(topicKey, containerWrapper);
            String name = this.getConsumerName(cclass);
            consumers.add(name);
            containerWrapper.register(name, cclass);
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework] createAnnotationComponentClass error:" + e + className, module);
        }
    }

    public void loadMehtodAnnotations(Class cclass, ContainerWrapper containerWrapper) {
        try {
            for (Method method : ClassUtil.getAllDecaredMethods(cclass)) {
                if (!method.isAnnotationPresent(OnEvent.class)) continue;
                this.addConsumerMethod(method, cclass, containerWrapper);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addConsumerMethod(Method method, Class cclass, ContainerWrapper containerWrapper) {
        OnEvent onEvent = method.getAnnotation(OnEvent.class);
        String consumerKey = TOPICNAME2 + onEvent.value();
        Collection<String> consumerMethods = this.getContainerConsumers(consumerKey, containerWrapper);
        String componentname = this.getConsumerName(cclass);
        consumerMethods.add((String)((Object)new ConsumerMethodHolder(componentname, method)));
    }

    public Collection<String> getContainerConsumers(String topicKey, ContainerWrapper containerWrapper) {
        ArrayList consumers = (ArrayList)containerWrapper.lookup(topicKey);
        if (consumers == null) {
            consumers = new ArrayList();
            containerWrapper.register(topicKey, consumers);
        }
        return consumers;
    }

    protected TreeSet createNewSet() {
        return new TreeSet(new Comparator(){

            public int compare(Object num1, Object num2) {
                String inum2;
                String inum1 = num1.getClass().getName();
                if (inum1.compareTo(inum2 = num2.getClass().getName()) < 1) {
                    return -1;
                }
                return 1;
            }
        });
    }

    public Boolean implementsInterface(Class cclass, Class interf) {
        for (Class<?> c : cclass.getInterfaces()) {
            if (!c.equals(interf)) continue;
            return true;
        }
        return false;
    }

    protected String getConsumerName(Class cclass) {
        Component cp;
        String name = "";
        name = cclass.isAnnotationPresent(Component.class) ? (UtilValidate.isEmpty((cp = cclass.getAnnotation(Component.class)).value()) ? cclass.getName() : cp.value()) : (cclass.isAnnotationPresent(Service.class) ? (UtilValidate.isEmpty((cp = cclass.getAnnotation(Service.class)).value()) ? cclass.getName() : cp.value()) : cclass.getName());
        return name;
    }
}

