/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.annotation.type;

import com.jdon.annotation.Introduce;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.access.TargetMetaDefHolder;
import com.jdon.container.annotation.AnnotationHolder;
import com.jdon.container.annotation.type.AnnotationScaner;
import com.jdon.container.annotation.type.Utils;
import com.jdon.container.interceptor.IntroduceInfoHolder;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.util.Debug;
import java.util.Set;

public class InroduceLoader {
    public static final String module = InroduceLoader.class.getName();
    private AnnotationScaner annotationScaner;
    private IntroduceInfoHolder introduceInfoHolder;

    public InroduceLoader(AnnotationScaner annotationScaner, IntroduceInfoHolder introduceInfoHolder) {
        this.annotationScaner = annotationScaner;
        this.introduceInfoHolder = introduceInfoHolder;
    }

    public void loadAnnotationIntroduceInfos(AnnotationHolder annotationHolder, AppContextWrapper context, ContainerWrapper containerWrapper) {
        Set<String> classes = this.annotationScaner.getScannedAnnotations(context).get(Introduce.class.getName());
        if (classes == null) {
            return;
        }
        Debug.logVerbose("[JdonFramework] found Annotation IntroduceInfo size:" + classes.size(), module);
        for (String className : classes) {
            this.createAnnotationIntroduceInfoClass(className, annotationHolder, containerWrapper);
        }
    }

    public void createAnnotationIntroduceInfoClass(String className, AnnotationHolder annotationHolder, ContainerWrapper containerWrapper) {
        try {
            Class targetclass = Utils.createClass(className);
            Introduce cp = targetclass.getAnnotation(Introduce.class);
            String[] adviceName = cp.value();
            this.introduceInfoHolder.addIntroduceInfo(adviceName, targetclass);
            String targetName = annotationHolder.getComponentName(targetclass);
            if (targetName == null) {
                TargetMetaDefHolder targetMetaDefHolder = (TargetMetaDefHolder)containerWrapper.lookup("targetMetaDefHolder");
                targetName = targetMetaDefHolder.lookupForName(targetclass.getName());
            }
            this.introduceInfoHolder.addTargetClassNames(targetclass, targetName);
            Debug.logVerbose("[JdonFramework] load Annotation IntroduceInfo name:" + adviceName + " target class:" + className, module);
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework] createAnnotationIntroduceInfoClass error:" + e + className, module);
        }
    }
}

