/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.builder;

import com.jdon.bussinessproxy.meta.POJOTargetMetaDef;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.builder.ContainerRegistry;
import com.jdon.container.builder.StartablecomponentsRegistry;
import com.jdon.container.config.ComponentMetaDef;
import com.jdon.container.config.aspect.AspectComponentsMetaDef;
import com.jdon.util.Debug;

public class XmlContainerRegistry
extends ContainerRegistry {
    public static final String module = XmlContainerRegistry.class.getName();

    public XmlContainerRegistry(ContainerWrapper containerWrapper) {
        super(containerWrapper);
    }

    public void registerComponentMetaDef(ComponentMetaDef componentMetaDef) {
        try {
            String name = componentMetaDef.getName();
            String[] construtors = componentMetaDef.getConstructors();
            String className = componentMetaDef.getClassName();
            Class cclass = this.createClass(className);
            this.containerWrapper.register(name, cclass, construtors);
            StartablecomponentsRegistry scr = (StartablecomponentsRegistry)this.containerWrapper.lookup("startablecomponentsRegistry");
            scr.add(cclass, name);
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] registerComponentMetaDef error:" + ex, module);
        }
    }

    public void registerPOJOTargetMetaDef(POJOTargetMetaDef pOJOTargetMetaDef) {
        try {
            String name = pOJOTargetMetaDef.getName();
            String className = pOJOTargetMetaDef.getClassName();
            Class cclass = this.createClass(className);
            String[] construtors = pOJOTargetMetaDef.getConstructors();
            this.containerWrapper.register(name, cclass, construtors);
            StartablecomponentsRegistry scr = (StartablecomponentsRegistry)this.containerWrapper.lookup("startablecomponentsRegistry");
            scr.add(cclass, name);
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] registerPOJOTargetMetaDef error:" + ex, module);
        }
    }

    public void registerAspectComponentMetaDef(AspectComponentsMetaDef componentMetaDef) {
        this.registerComponentMetaDef(componentMetaDef);
    }

    private Class createClass(String className) {
        Class<?> classService = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            classService = classLoader.loadClass(className);
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] createClass:" + ex, module);
        }
        return classService;
    }
}

