/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.config.aspect;

import com.jdon.container.config.aspect.AspectComponentsMetaDef;
import com.jdon.controller.config.XmlParser;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.util.Debug;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class AopInterceptorsXmlLoader
extends XmlParser {
    public static final String module = AopInterceptorsXmlLoader.class.getName();
    private AppContextWrapper context;

    public AopInterceptorsXmlLoader(AppContextWrapper context) {
        this.context = context;
    }

    public AopInterceptorsXmlLoader() {
    }

    protected InputStream getInputStream(String configFileName) throws Exception {
        InputStream xmlStream = this.fileLocator.getConfPathXmlStream(configFileName);
        if (xmlStream == null && this.context != null) {
            xmlStream = this.context.getResourceAsStream(configFileName);
        }
        return xmlStream;
    }

    public void parse(Element root, Map mps) throws Exception {
        List interceptors = root.getChildren("interceptor");
        Debug.logVerbose("[JdonFramework] found interceptor size:" + interceptors.size(), module);
        for (Element component : interceptors) {
            String name = component.getAttributeValue("name");
            Debug.logVerbose("[JdonFramework] found interceptor name:" + name, module);
            String className = component.getAttributeValue("class");
            String pointcut = component.getAttributeValue("pointcut");
            List mappings = component.getChildren("constructor");
            String[] constructors = null;
            if (mappings != null && mappings.size() != 0) {
                constructors = new String[mappings.size()];
                int j = 0;
                for (Element constructor : mappings) {
                    String value = constructor.getAttributeValue("value");
                    Debug.logVerbose("[JdonFramework] interceptor " + name + "constructor=" + value, module);
                    constructors[j] = value;
                    ++j;
                }
            }
            AspectComponentsMetaDef componentMetaDef = constructors != null ? new AspectComponentsMetaDef(name, className, constructors, pointcut) : new AspectComponentsMetaDef(name, className, pointcut);
            mps.put(name, componentMetaDef);
        }
    }
}

