/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.interceptor;

import com.jdon.annotation.pointcut.After;
import com.jdon.annotation.pointcut.Before;
import com.jdon.annotation.pointcut.method.Input;
import com.jdon.annotation.pointcut.method.Returning;
import com.jdon.container.interceptor.IntroduceInfo;
import com.jdon.container.pico.Startable;
import com.jdon.util.Debug;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodProxy;

public class BeforeAfterMethodTarget
implements Startable {
    private static final String module = BeforeAfterMethodTarget.class.getName();
    private Object target;
    private Object interceptor;
    private IntroduceInfo iinfo;

    public BeforeAfterMethodTarget(Object target, Object interceptor, IntroduceInfo iinfo) {
        this.target = target;
        this.interceptor = interceptor;
        this.iinfo = iinfo;
    }

    public Object invoke(Method invokedmethod, Object[] args, MethodProxy methodProxy) throws Throwable, Exception {
        if (invokedmethod.getName().equals("finalize")) {
            return null;
        }
        Object result = null;
        try {
            Method adviceAfterTargetMethod;
            Method adviceBeforeTargetMethod;
            Debug.logVerbose("[JdonFramework] enter FixedMethodInvocation", module);
            if (this.iinfo != null && (adviceBeforeTargetMethod = this.getAdviceBeforeTargetMethod(this.target, this.iinfo, invokedmethod)) != null && adviceBeforeTargetMethod.getName().equals(invokedmethod.getName())) {
                Object returning = this.doBefore(adviceBeforeTargetMethod, args, this.interceptor, this.iinfo);
                this.injectOriginReturning(returning, adviceBeforeTargetMethod, args, this.iinfo);
            }
            result = methodProxy.invoke(this.target, args);
            if (this.iinfo != null && (adviceAfterTargetMethod = this.getAdviceAfterTargetMethod(this.target, this.iinfo, invokedmethod)) != null && adviceAfterTargetMethod.getName().equals(invokedmethod.getName())) {
                result = this.doAfter(adviceAfterTargetMethod, result, this.iinfo, this.interceptor);
            }
            Debug.logVerbose("<----->FixedMethodInvocation end:", module);
        }
        catch (Exception ex) {
            Debug.logError(ex, module);
            throw new Exception(ex);
        }
        catch (Throwable ex) {
            throw new Throwable(ex);
        }
        return result;
    }

    private Method getAdviceBeforeTargetMethod(Object target, IntroduceInfo iinfo, Method invokedmethod) {
        Method m = iinfo.getBefores().get(invokedmethod.getName());
        if (m != null) {
            return m;
        }
        for (Method method : target.getClass().getMethods()) {
            if (!method.isAnnotationPresent(Before.class)) continue;
            m = method;
            iinfo.getBefores().put(invokedmethod.getName(), method);
        }
        return m;
    }

    private Method getAdviceAfterTargetMethod(Object target, IntroduceInfo iinfo, Method invokedmethod) {
        Method m = iinfo.getAfters().get(invokedmethod.getName());
        if (m != null) {
            return m;
        }
        for (Method method : target.getClass().getMethods()) {
            if (!method.isAnnotationPresent(After.class)) continue;
            m = method;
            iinfo.getAfters().put(invokedmethod.getName(), method);
        }
        return m;
    }

    private Object doBefore(Method adviceBeforeTargetMethod, Object[] targetParameters, Object interceptor, IntroduceInfo iinfo) {
        Object returning = null;
        try {
            Before before = adviceBeforeTargetMethod.getAnnotation(Before.class);
            Method interceptorMethod = iinfo.getMethods().get(adviceBeforeTargetMethod);
            if (interceptorMethod == null) {
                for (Method interceptorMethod2 : interceptor.getClass().getMethods()) {
                    String mName = interceptorMethod2.getName();
                    if (!before.value().equals(mName)) continue;
                    interceptorMethod = interceptorMethod2;
                    break;
                }
                iinfo.getMethods().put(adviceBeforeTargetMethod, interceptorMethod);
            }
            returning = this.executeBeforeAdvice(adviceBeforeTargetMethod, targetParameters, interceptorMethod, interceptor, iinfo);
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework]doBefore error: " + e, module);
        }
        return returning;
    }

    private Object executeBeforeAdvice(Method invokedmethod, Object[] targetParameters, Method interceptorMethod, Object interceptor, IntroduceInfo iinfo) {
        Object returning = null;
        try {
            Class<?>[] iParamTypes = interceptorMethod.getParameterTypes();
            Object[] args = new Object[iParamTypes.length];
            Object requiredParam = this.getInputparameter(invokedmethod, targetParameters, interceptorMethod, iinfo);
            Integer posIn = iinfo.getIntroducedParametersPositions().get(interceptorMethod.getName());
            args[posIn.intValue()] = requiredParam;
            returning = interceptorMethod.invoke(interceptor, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return returning;
    }

    private Object getInputparameter(Method method, Object[] targetParameters, Method interceptorMethod, IntroduceInfo iinfo) {
        Object input = null;
        Integer posIn = iinfo.getInputParametersPositions().get(method.getName());
        if (posIn != null) {
            input = targetParameters[posIn];
            return input;
        }
        try {
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            Class<?>[] parameterTypes = method.getParameterTypes();
            int i = 0;
            Annotation[][] arr$ = parameterAnnotations;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Annotation[] annotations;
                block3: for (Annotation annotation : annotations = arr$[i$]) {
                    if (!(annotation instanceof Input)) continue;
                    Class<?>[] iParamTypes = interceptorMethod.getParameterTypes();
                    for (int j = 0; j < iParamTypes.length; ++j) {
                        if (!iParamTypes[j].isAssignableFrom(parameterTypes[i]) || parameterTypes[i] == null) continue;
                        input = targetParameters[i];
                        iinfo.getInputParametersPositions().put(method.getName(), i);
                        iinfo.getIntroducedParametersPositions().put(interceptorMethod.getName(), j);
                        continue block3;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Debug.logError("getInputparameter" + e, module);
        }
        return input;
    }

    private void injectOriginReturning(Object returning, Method adviceBeforeTargetMethod, Object[] targetParameters, IntroduceInfo iinfo) {
        if (returning == null) {
            return;
        }
        Integer posIn = iinfo.getReturnParametersPositions().get(adviceBeforeTargetMethod.getName());
        if (posIn != null) {
            targetParameters[posIn.intValue()] = returning;
            return;
        }
        try {
            Annotation[][] parameterAnnotations = adviceBeforeTargetMethod.getParameterAnnotations();
            int i = 0;
            Annotation[][] arr$ = parameterAnnotations;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = arr$[i$]) {
                    if (!(annotation instanceof Returning) || targetParameters[i] == null || !targetParameters[i].getClass().isAssignableFrom(returning.getClass())) continue;
                    targetParameters[i] = returning;
                    iinfo.getReturnParametersPositions().put(adviceBeforeTargetMethod.getName(), i);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Debug.logError("injectOriginReturning" + e, module);
        }
    }

    private Object doAfter(Method adviceAfterTargetMethod, Object result, IntroduceInfo iinfo, Object interceptor) {
        Object resultReturning = null;
        try {
            After after = adviceAfterTargetMethod.getAnnotation(After.class);
            Method interceptorMethod = iinfo.getMethods().get(adviceAfterTargetMethod.getName());
            if (interceptorMethod == null) {
                for (Method interceptorMethod2 : interceptor.getClass().getMethods()) {
                    String mName = interceptorMethod2.getName();
                    if (!after.value().equals(mName)) continue;
                    interceptorMethod = interceptorMethod2;
                    break;
                }
                iinfo.getMethods().put(adviceAfterTargetMethod, interceptorMethod);
            }
            resultReturning = this.execAfterAdvice(result, interceptorMethod, interceptor, iinfo);
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework]doAfter error: " + e, module);
        }
        return resultReturning;
    }

    private Object execAfterAdvice(Object result, Method interceptorMethod, Object interceptor, IntroduceInfo iinfo) {
        Object resultReturning = null;
        try {
            Object[] args = this.getInjectResturingIntoAdvice(result, interceptorMethod, iinfo);
            resultReturning = interceptorMethod.invoke(interceptor, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return resultReturning;
    }

    private Object[] getInjectResturingIntoAdvice(Object result, Method interceptorMethod, IntroduceInfo iinfo) {
        Class<?>[] iParamTypes = interceptorMethod.getParameterTypes();
        Object[] args = new Object[iParamTypes.length];
        Integer posIn = iinfo.getIntroducedParametersPositions().get(interceptorMethod.getName());
        if (posIn != null) {
            args[posIn.intValue()] = result;
            return args;
        }
        try {
            for (int i = 0; i < iParamTypes.length; ++i) {
                if (!iParamTypes[i].isAssignableFrom(result.getClass())) continue;
                args[i] = result;
                iinfo.getIntroducedParametersPositions().put(interceptorMethod.getName(), i);
            }
        }
        catch (Exception e) {
            Debug.logError("getInjectResturingIntoAdvice" + e, module);
        }
        return args;
    }

    public void clear() {
        Startable st;
        if (this.iinfo != null) {
            this.iinfo.clear();
            this.iinfo = null;
        }
        if (this.interceptor != null) {
            if (this.interceptor instanceof Startable) {
                st = (Startable)this.interceptor;
                try {
                    st.stop();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.interceptor = null;
        }
        if (this.target != null) {
            if (this.target instanceof Startable) {
                st = (Startable)this.target;
                try {
                    st.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.target = null;
        }
    }

    public void start() {
    }

    public void stop() {
        this.clear();
    }
}

