/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.pico;

import com.jdon.container.ContainerWrapper;
import com.jdon.container.RegistryDirectory;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.container.pico.ConfigInfo;
import com.jdon.container.pico.JdonComponentAdapterFactory;
import com.jdon.container.pico.JdonPicoContainer;
import com.jdon.domain.advsior.ComponentAdvsior;
import com.jdon.util.Debug;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ConstantParameter;

public class PicoContainerWrapper
implements ContainerWrapper,
Serializable {
    private static final long serialVersionUID = 6003045437916961392L;
    public static final String module = PicoContainerWrapper.class.getName();
    private JdonPicoContainer container;
    private RegistryDirectory registryDirectory;
    private volatile boolean start;

    public PicoContainerWrapper(ConfigInfo configInfo) {
        this.container = new JdonPicoContainer(new JdonComponentAdapterFactory(configInfo));
        this.registryDirectory = new RegistryDirectory();
    }

    public synchronized void registerContainerCallback() {
        ContainerCallback containerCallback = new ContainerCallback(this);
        this.register("ContainerCallback", containerCallback);
        this.register("componentAdvsior", new ComponentAdvsior(containerCallback));
    }

    public synchronized void register(String name, Class className) {
        try {
            Debug.logVerbose("[JdonFramework]register: name=" + name + " class=" + className.getName(), module);
            this.container.registerComponentImplementation(name, className);
            this.registryDirectory.addComponentName(className, name);
        }
        catch (Exception ex) {
            Debug.logWarning(" registe error: " + name, module);
        }
    }

    public synchronized void register(String name) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> oClass = classLoader.loadClass(name);
            Debug.logVerbose("[JdonFramework]register: name=" + name + " class=" + oClass.getName(), module);
            this.register(name, oClass);
            this.registryDirectory.addComponentName(oClass, name);
        }
        catch (Exception ex) {
            Debug.logWarning(" registe error: " + name + " should be a full class's name", module);
        }
    }

    public synchronized void register(String name, Class className, String[] constructors) {
        block6: {
            if (constructors == null) {
                this.register(name, className);
                return;
            }
            try {
                Debug.logVerbose("[JdonFramework]register: name=" + name + " class=" + className.getName(), module);
                Debug.logVerbose("[JdonFramework] constructor params size =" + constructors.length, module);
                Constructor<?>[] cs = className.getConstructors();
                Class<?>[] types = cs[0].getParameterTypes();
                Debug.logVerbose("[JdonFramework] constructor first ParameterType is " + types[0], module);
                if (types[0].isAssignableFrom(String.class)) {
                    Debug.logVerbose("[JdonFramework]parameter type is  String s1, String s2 ", module);
                    Parameter[] params = new Parameter[constructors.length];
                    for (int i = 0; i < constructors.length; ++i) {
                        ConstantParameter param = new ConstantParameter((Object)new String(constructors[i]));
                        Debug.logVerbose("[JdonFramework] register its constructor value is " + constructors[i], module);
                        params[i] = param;
                    }
                    this.container.registerComponentImplementation((Object)name, className, params);
                    this.registryDirectory.addComponentName(className, name);
                    break block6;
                }
                if (types[0].isArray()) {
                    Debug.logVerbose("[JdonFramework]parameter type is String[] " + constructors, module);
                    ConstantParameter param = new ConstantParameter((Object)constructors);
                    Parameter[] params = new Parameter[]{param};
                    this.container.registerComponentImplementation((Object)name, className, params);
                    this.registryDirectory.addComponentName(className, name);
                    break block6;
                }
                throw new Exception("constructors.types netiher is not String[] or String s1, String s2...");
            }
            catch (Exception ex) {
                Debug.logError(" registe " + name + " error: " + ex, module);
            }
        }
    }

    public synchronized void register(String name, Object instance) {
        try {
            Debug.logVerbose("[JdonFramework]register: name=" + name + " class=" + instance.getClass().getName(), module);
            this.container.registerComponentInstance(name, instance);
            this.registryDirectory.addComponentName(instance.getClass(), name);
        }
        catch (Exception ex) {
            Debug.logWarning(" registe error: " + name, module);
        }
    }

    public synchronized void start() {
        try {
            this.container.start();
        }
        catch (RuntimeException e) {
            Debug.logError("[JdonFramework] container start error: " + e, module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        try {
            this.container.stop();
            this.container.dispose();
            this.container = null;
            this.registryDirectory = null;
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework] container stop error: " + e, module);
        }
        finally {
            this.start = false;
        }
    }

    public boolean isStart() {
        return this.start;
    }

    public synchronized void setStart(boolean start) {
        if (start) {
            this.notifyAll();
        }
        this.start = start;
    }

    public List getAllInstances() {
        if (!this.isStart()) {
            Debug.logError("container not start", module);
            return null;
        }
        return this.container.getComponentInstances();
    }

    public Object lookup(String name) {
        Object object = this.container.getComponentInstance(name);
        if (object == null) {
            Debug.logWarning("[JdonFramework]Not find the component in container :" + name, module);
        }
        return object;
    }

    public Object lookupOriginal(String name) {
        Object object = null;
        Map orignals = (Map)this.lookup("OrignalKey");
        if (orignals != null) {
            object = orignals.get(name);
        }
        if (object == null) {
            object = this.lookup(name);
        }
        return object;
    }

    public Object getComponentNewInstance(String name) {
        Debug.logVerbose("[JdonFramework]getComponentNewInstance: name=" + name, module);
        ComponentAdapter componentAdapter = this.container.getComponentAdapter(name);
        if (componentAdapter == null) {
            Debug.logWarning("[JdonFramework]Not find the component in container :" + name, module);
            return null;
        }
        return componentAdapter.getComponentInstance((PicoContainer)this.container);
    }

    public Class getComponentClass(String name) {
        Debug.logVerbose("[JdonFramework]getComponentClass: name=" + name, module);
        ComponentAdapter componentAdapter = this.container.getComponentAdapter(name);
        if (componentAdapter == null) {
            Debug.logVerbose("[JdonFramework]Not find the component in container :" + name, module);
        }
        return componentAdapter.getComponentImplementation();
    }

    public List getComponentInstancesOfType(Class componentType) {
        if (!this.isStart()) {
            Debug.logError("container not start", module);
            return null;
        }
        ArrayList result = new ArrayList();
        Map orignals = (Map)this.lookup("OrignalKey");
        if (orignals != null) {
            for (Object o : orignals.values()) {
                if (!componentType.isAssignableFrom(o.getClass())) continue;
                result.add(o);
            }
        }
        result.addAll(this.container.getComponentInstancesOfType(componentType));
        return result;
    }

    public RegistryDirectory getRegistryDirectory() {
        if (!this.start) {
            Debug.logError("container not start, not return RegistryNamesHolder", module);
            return null;
        }
        return this.registryDirectory;
    }
}

