/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.startup;

import com.jdon.container.startup.ContainerSetupScript;
import com.jdon.controller.context.web.ServletContextWrapper;
import com.jdon.util.Debug;
import com.jdon.util.StringUtil;
import com.jdon.util.UtilValidate;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServletContainerListener
implements ServletContextListener,
Serializable {
    private static final Logger logger = LogManager.getLogger((String)"JdonFramework");
    private static final long serialVersionUID = -3277156967613387119L;
    public static final String module = ServletContainerListener.class.getName();
    private final ContainerSetupScript css = new ContainerSetupScript();

    public void contextInitialized(ServletContextEvent event) {
        ServletContext scontext = event.getServletContext();
        ServletContextWrapper context = new ServletContextWrapper(scontext);
        this.css.initialized(context);
        Debug.logVerbose("[JdonFramework]contextInitialized", module);
        String app_configFile = context.getInitParameter("modelmapping-config");
        if (UtilValidate.isEmpty(app_configFile)) {
            Debug.logWarning("[JdonFramework] not locate a configuration in web.xml :", module);
            this.css.prepare("", context);
        } else {
            String[] configs = StringUtil.split(app_configFile, ",");
            for (int i = 0; i < configs.length; ++i) {
                Debug.logVerbose("[JdonFramework] locate a configuration in web.xml :" + configs[i], module);
                this.css.prepare(configs[i], context);
            }
        }
        Debug.logVerbose("[JdonFramework]ServletContainerListener is preparing...", module);
        logger.info("Jdon Framework is ready ..");
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext scontext = event.getServletContext();
        ServletContextWrapper context = new ServletContextWrapper(scontext);
        this.css.destroyed(context);
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
    }
}

