/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.domain.message;

import com.jdon.annotation.model.Send;
import com.jdon.async.EventMessageFirer;
import com.jdon.async.future.FutureListener;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.container.pico.Startable;
import com.jdon.domain.message.DomainMessage;
import com.jdon.util.Debug;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class MessageInterceptor
implements MethodInterceptor,
Startable {
    public static final String module = MessageInterceptor.class.getName();
    private ContainerCallback containerCallback;
    protected EventMessageFirer eventMessageFirer;

    public MessageInterceptor(ContainerCallback containerCallback, EventMessageFirer eventMessageFirer) {
        this.containerCallback = containerCallback;
        this.eventMessageFirer = eventMessageFirer;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!invocation.getMethod().isAnnotationPresent(Send.class)) {
            return invocation.proceed();
        }
        Send send = invocation.getMethod().getAnnotation(Send.class);
        String channel = send.value();
        Object result = null;
        try {
            result = invocation.proceed();
            DomainMessage message = null;
            message = DomainMessage.class.isAssignableFrom(result.getClass()) ? (DomainMessage)result : new DomainMessage(result);
            this.eventMessageFirer.fire(message, send);
            Object listener = this.containerCallback.getContainerWrapper().lookup(channel);
            if (listener != null && listener instanceof FutureListener) {
                this.eventMessageFirer.fire(message, send, (FutureListener)listener);
            }
            this.eventMessageFirer.fireToModel(message, send, invocation);
        }
        catch (Exception e) {
            Debug.logError("invoke error: " + e, module);
        }
        return result;
    }

    public void start() {
    }

    public void stop() {
        this.containerCallback = null;
        this.eventMessageFirer = null;
    }
}

