/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.domain.model.cache;

import com.jdon.domain.advsior.ModelAdvisor;
import com.jdon.domain.model.cache.ModelCacheManager;
import com.jdon.domain.model.cache.ModelKey;
import com.jdon.domain.model.cache.ModelManager;
import com.jdon.domain.model.injection.ModelProxyInjection;
import com.jdon.util.Debug;

public class ModelManagerImp
implements ModelManager {
    public static final String module = ModelManagerImp.class.getName();
    private final ModelCacheManager modelCacheManager;
    private final ModelProxyInjection modelProxyInjection;
    private final ModelAdvisor modelAdvisor;

    public ModelManagerImp(ModelCacheManager modelCacheManager, ModelProxyInjection modelProxyInjection, ModelAdvisor modelAdvisor) {
        this.modelCacheManager = modelCacheManager;
        this.modelProxyInjection = modelProxyInjection;
        this.modelAdvisor = modelAdvisor;
    }

    public Object addCache(ModelKey modelKey, Object model) {
        if (modelKey == null || modelKey.getDataKey() == null || modelKey.getModelClass() == null) {
            return null;
        }
        String modelClassName = null;
        try {
            modelClassName = modelKey.getModelClass().getName();
            this.modelProxyInjection.injectProperties(model);
            model = this.modelAdvisor.createProxy(model);
            this.modelCacheManager.saveCache(modelKey.getDataKey(), modelClassName, model);
        }
        catch (Exception e) {
            Debug.logError("addCache error:" + e, module);
        }
        return model;
    }

    public void addCache(Object key, String className, Object model) {
        if (key == null) {
            return;
        }
        this.modelCacheManager.saveCache(key, className, model);
    }

    public Object getCache(ModelKey modelKey) {
        String modelClassName = null;
        if (modelKey.getModelClass() != null) {
            modelClassName = modelKey.getModelClass().getName();
            return this.modelCacheManager.getCache(modelKey.getDataKey(), modelClassName);
        }
        return null;
    }

    public Object getCache(Object key, String className) {
        return this.modelCacheManager.getCache(key, className);
    }

    public void removeCache(Object dataKey) throws Exception {
        this.modelCacheManager.removeCache(dataKey);
    }

    public void clearCache() {
        this.modelCacheManager.clearCache();
    }

    public boolean isNull(String s) {
        boolean isNull = false;
        if (s == null) {
            isNull = true;
        } else if (s.equals("")) {
            isNull = true;
        } else if (s.equals("null")) {
            isNull = true;
        }
        return isNull;
    }

    public boolean containInCache(ModelKey modelKey) {
        if (modelKey == null || modelKey.getModelClass() == null) {
            return false;
        }
        return this.modelCacheManager.containInCache(modelKey.getDataKey(), modelKey.getModelClass().getName());
    }
}

