/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.async.disruptor;

import com.jdon.async.disruptor.DisruptorParams;
import com.jdon.async.disruptor.DomainEventHandlerAdapter;
import com.jdon.async.disruptor.EventDisruptorFactory;
import com.jdon.async.disruptor.pool.DisruptorPoolFactory;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.container.pico.Startable;
import com.jdon.domain.message.DomainEventDispatchHandler;
import com.jdon.domain.message.DomainEventHandler;
import com.jdon.domain.message.consumer.ConsumerMethodHolder;
import com.jdon.util.Debug;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.EventHandlerGroup;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisruptorFactory
implements Startable {
    public static final String module = DisruptorFactory.class.getName();
    protected final ConcurrentHashMap<String, TreeSet<DomainEventHandler>> handlesMap;
    private String RingBufferSize;
    private ContainerWrapper containerWrapper;
    private DisruptorPoolFactory disruptorPoolFactory;

    public DisruptorFactory(DisruptorParams disruptorParams, ContainerCallback containerCallback, DisruptorPoolFactory disruptorPoolFactory) {
        this.RingBufferSize = disruptorParams.getRingBufferSize();
        this.containerWrapper = containerCallback.getContainerWrapper();
        this.handlesMap = new ConcurrentHashMap();
        this.disruptorPoolFactory = disruptorPoolFactory;
        this.disruptorPoolFactory.setDisruptorFactory(this);
    }

    public DisruptorFactory() {
        this.RingBufferSize = "8";
        this.containerWrapper = null;
        this.handlesMap = new ConcurrentHashMap();
        this.disruptorPoolFactory = new DisruptorPoolFactory();
        this.disruptorPoolFactory.setDisruptorFactory(this);
    }

    public Disruptor createDw(String topic) {
        int size = Integer.parseInt(this.RingBufferSize);
        return new Disruptor((EventFactory)new EventDisruptorFactory(), size, (Executor)Executors.newCachedThreadPool());
    }

    public Disruptor createSingleDw(String topic) {
        int size = Integer.parseInt(this.RingBufferSize);
        BlockingWaitStrategy waitStrategy = new BlockingWaitStrategy();
        return new Disruptor((EventFactory)new EventDisruptorFactory(), size, (Executor)Executors.newCachedThreadPool(), ProducerType.SINGLE, (WaitStrategy)waitStrategy);
    }

    public Disruptor addEventMessageHandler(Disruptor dw, String topic, TreeSet<DomainEventHandler> handlers) {
        if (handlers.size() == 0) {
            return null;
        }
        EventHandlerGroup eh = null;
        for (DomainEventHandler handler : handlers) {
            DomainEventHandlerAdapter dea = new DomainEventHandlerAdapter(handler);
            if (eh == null) {
                eh = dw.handleEventsWith(new EventHandler[]{dea});
                continue;
            }
            eh = eh.handleEventsWith(new EventHandler[]{dea});
        }
        return dw;
    }

    public Disruptor getDisruptor(String topic) {
        return this.disruptorPoolFactory.getDisruptor(topic);
    }

    public void releaseDisruptor(Object owner) {
    }

    public Disruptor createDisruptor(String topic) {
        TreeSet handlers = this.getHandles(topic);
        if (handlers == null) {
            return null;
        }
        Disruptor dw = this.createDw(topic);
        Disruptor disruptor = this.addEventMessageHandler(dw, topic, handlers);
        if (disruptor == null) {
            return null;
        }
        disruptor.start();
        return disruptor;
    }

    public Disruptor createSingleDisruptor(String topic) {
        TreeSet handlers = this.getHandles(topic);
        if (handlers == null) {
            return null;
        }
        Disruptor dw = this.createSingleDw(topic);
        Disruptor disruptor = this.addEventMessageHandler(dw, topic, handlers);
        if (disruptor == null) {
            return null;
        }
        disruptor.start();
        return disruptor;
    }

    private TreeSet getHandles(String topic) {
        TreeSet<DomainEventHandler> handlers = this.handlesMap.get(topic);
        if (handlers == null) {
            handlers = this.getTreeSet();
            handlers.addAll(this.loadEvenHandler(topic));
            handlers.addAll(this.loadOnEventConsumers(topic));
            if (handlers.size() == 0) {
                Object o = this.containerWrapper.lookup(topic);
                if (o == null) {
                    Debug.logError("[Jdonframework]no found the class annotated with @Consumer(" + topic + ") ", module);
                }
                return null;
            }
            this.handlesMap.put(topic, handlers);
        }
        return handlers;
    }

    public boolean isContain(String topic) {
        return this.containerWrapper.lookup("CONSUMER_TOPIC" + topic) != null || this.containerWrapper.lookup("MEHTOD_TOPIC" + topic) != null;
    }

    protected Collection loadEvenHandler(String topic) {
        ArrayList<DomainEventHandler> ehs = new ArrayList<DomainEventHandler>();
        Collection consumers = (Collection)this.containerWrapper.lookup("CONSUMER_TOPIC" + topic);
        if (consumers == null || consumers.size() == 0) {
            Debug.logWarning("[Jdonframework]there is no any consumer class annotated with @Consumer(" + topic + ") ", module);
            return ehs;
        }
        for (String consumerName : consumers) {
            DomainEventHandler eh = (DomainEventHandler)this.containerWrapper.lookup(consumerName);
            ehs.add(eh);
        }
        return ehs;
    }

    protected Collection loadOnEventConsumers(String topic) {
        ArrayList<DomainEventDispatchHandler> ehs = new ArrayList<DomainEventDispatchHandler>();
        Collection consumerMethods = (Collection)this.containerWrapper.lookup("MEHTOD_TOPIC" + topic);
        if (consumerMethods == null) {
            return ehs;
        }
        for (Object o : consumerMethods) {
            ConsumerMethodHolder consumerMethodHolder = (ConsumerMethodHolder)o;
            DomainEventDispatchHandler domainEventDispatchHandler = new DomainEventDispatchHandler(consumerMethodHolder, this.containerWrapper);
            ehs.add(domainEventDispatchHandler);
        }
        return ehs;
    }

    public TreeSet<DomainEventHandler> getTreeSet() {
        return new TreeSet<DomainEventHandler>(new Comparator(){

            public int compare(Object num1, Object num2) {
                String inum2;
                String inum1 = num1 instanceof DomainEventDispatchHandler ? ((DomainEventDispatchHandler)num1).getSortName() : num1.getClass().getName();
                if (inum1.compareTo(inum2 = num2 instanceof DomainEventDispatchHandler ? ((DomainEventDispatchHandler)num2).getSortName() : num2.getClass().getName()) < 1) {
                    return -1;
                }
                return 1;
            }
        });
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.containerWrapper = null;
        this.handlesMap.clear();
        this.RingBufferSize = null;
    }
}

