/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.async.disruptor.pool;

import com.jdon.async.disruptor.DisruptorFactory;
import com.jdon.async.disruptor.pool.DisruptorSwitcher;
import com.jdon.util.Debug;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.picocontainer.Startable;

public class DisruptorPoolFactory
implements Startable {
    public static final String module = DisruptorPoolFactory.class.getName();
    private DisruptorSwitcher disruptorSwitcher;
    private DisruptorFactory disruptorFactory;
    private ConcurrentHashMap<String, Disruptor> topicDisruptors;
    private ScheduledExecutorService scheduExecStatic = Executors.newScheduledThreadPool(1);

    public DisruptorPoolFactory() {
        this.disruptorSwitcher = new DisruptorSwitcher();
        this.topicDisruptors = new ConcurrentHashMap();
    }

    public void start() {
        Runnable task = new Runnable(){

            public void run() {
                DisruptorPoolFactory.this.stopDisruptor();
            }
        };
        this.scheduExecStatic.scheduleAtFixedRate(task, 3600L, 3600L, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.topicDisruptors != null) {
            this.stopDisruptor();
            this.topicDisruptors.clear();
            this.topicDisruptors = null;
        }
        this.disruptorFactory = null;
        this.scheduExecStatic.shutdownNow();
    }

    private void stopDisruptor() {
        HashMap<String, Disruptor> mydisruptors = new HashMap<String, Disruptor>(this.topicDisruptors);
        this.topicDisruptors.clear();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        for (String topic : mydisruptors.keySet()) {
            Disruptor disruptor = (Disruptor)mydisruptors.get(topic);
            try {
                disruptor.halt();
            }
            catch (Exception e) {}
        }
        mydisruptors.clear();
    }

    public Disruptor createAutoDisruptor(String topic) {
        if (this.disruptorSwitcher.getCommandTopic() != null) {
            return this.disruptorFactory.createSingleDisruptor(topic);
        }
        return this.disruptorFactory.createDisruptor(topic);
    }

    public Disruptor getDisruptor(String topic) {
        Disruptor disruptor = this.topicDisruptors.get(topic);
        if (disruptor == null) {
            disruptor = this.createAutoDisruptor(topic);
            if (disruptor == null) {
                Debug.logWarning("not create disruptor for " + topic, module);
                return null;
            }
            Disruptor disruptorOLd = this.topicDisruptors.putIfAbsent(topic, disruptor);
            if (disruptorOLd != null) {
                disruptor = disruptorOLd;
            }
        }
        return disruptor;
    }

    public DisruptorFactory getDisruptorFactory() {
        return this.disruptorFactory;
    }

    public void setDisruptorFactory(DisruptorFactory disruptorFactory) {
        this.disruptorFactory = disruptorFactory;
    }
}

