/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.async.future;

import com.jdon.async.future.EventResultFuture;
import com.jdon.domain.message.DomainMessage;
import com.jdon.util.Debug;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ChannelExecutor {
    private static final String module = ChannelExecutor.class.getName();
    private ExecutorService executor = Executors.newCachedThreadPool();

    public ChannelExecutor(String maxconcurrentTaskCount) {
    }

    public void actionListener(DomainMessage domainMessage) {
        EventResultFuture eventMessageFuture = (EventResultFuture)domainMessage.getEventResultHandler();
        try {
            if (eventMessageFuture.getMessageListener() == null) {
                return;
            }
            if (eventMessageFuture.isAsyn()) {
                this.executor.execute(eventMessageFuture.getFutureTask());
            } else {
                eventMessageFuture.getFutureTask().run();
            }
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework]actionChannelListener() error" + e, module);
        }
    }

    public void stop() {
        while (!this.executor.isShutdown()) {
            try {
                this.executor.shutdownNow();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.executor = null;
    }
}

