/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.builder;

import com.jdon.aop.interceptor.InterceptorsChain;
import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.bussinessproxy.meta.POJOTargetMetaDef;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.access.TargetMetaDefHolder;
import com.jdon.container.access.xml.AppConfigureCollection;
import com.jdon.container.access.xml.TargetMetaDefXmlLoader;
import com.jdon.container.builder.ContainerRegistryBuilder;
import com.jdon.container.builder.StartablecomponentsRegistry;
import com.jdon.container.builder.XmlContainerRegistry;
import com.jdon.container.config.ComponentMetaDef;
import com.jdon.container.config.ContainerComponents;
import com.jdon.container.config.aspect.AspectComponentsMetaDef;
import com.jdon.util.Debug;
import java.util.Iterator;
import java.util.Map;

public class DefaultContainerBuilder
implements ContainerRegistryBuilder {
    public static final String module = DefaultContainerBuilder.class.getName();
    protected final ContainerComponents basicComponents;
    protected final ContainerComponents aspectConfigComponents;
    protected final XmlContainerRegistry xmlcontainerRegistry;
    protected final ContainerWrapper containerWrapper;
    protected volatile boolean startup;

    public DefaultContainerBuilder(ContainerWrapper containerWrapper, ContainerComponents basicComponents, ContainerComponents aspectConfigComponents) {
        this.basicComponents = basicComponents;
        this.aspectConfigComponents = aspectConfigComponents;
        this.xmlcontainerRegistry = new XmlContainerRegistry(containerWrapper);
        this.containerWrapper = containerWrapper;
    }

    public ContainerWrapper getContainerWrapper() {
        return this.containerWrapper;
    }

    public void registerAppRoot(String configureFileName) throws Exception {
        try {
            AppConfigureCollection existedAppConfigureFiles = (AppConfigureCollection)this.containerWrapper.lookup("AppConfigureFiles");
            if (existedAppConfigureFiles == null) {
                this.xmlcontainerRegistry.registerAppRoot();
                existedAppConfigureFiles = (AppConfigureCollection)this.containerWrapper.lookup("AppConfigureFiles");
            }
            if (!existedAppConfigureFiles.getConfigList().contains(configureFileName)) {
                Debug.logInfo("[JdonFramework]found jdonframework configuration:" + configureFileName, module);
                existedAppConfigureFiles.addConfigList(configureFileName);
            }
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] found jdonframework configuration error:" + ex, module);
            throw new Exception(ex);
        }
    }

    public void registerComponents() throws Exception {
        Debug.logVerbose("[JdonFramework] note: registe all basic components in container.xml size=" + this.basicComponents.size(), module);
        try {
            Iterator iter = this.basicComponents.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                ComponentMetaDef componentMetaDef = this.basicComponents.getComponentMetaDef(name);
                this.xmlcontainerRegistry.registerComponentMetaDef(componentMetaDef);
            }
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] register basiceComponents error:" + ex, module);
            throw new Exception(ex);
        }
    }

    public void registerAspectComponents() throws Exception {
        Debug.logVerbose("[JdonFramework] note: registe aspect components ", module);
        try {
            InterceptorsChain existedInterceptorsChain = (InterceptorsChain)this.containerWrapper.lookup("interceptorsChain");
            Iterator iter = this.aspectConfigComponents.iterator();
            Debug.logVerbose("[JdonFramework] 3 aspectConfigComponents size:" + this.aspectConfigComponents.size(), module);
            while (iter.hasNext()) {
                String name = (String)iter.next();
                AspectComponentsMetaDef componentMetaDef = (AspectComponentsMetaDef)this.aspectConfigComponents.getComponentMetaDef(name);
                this.xmlcontainerRegistry.registerAspectComponentMetaDef(componentMetaDef);
                existedInterceptorsChain.addInterceptor(componentMetaDef.getPointcut(), name);
            }
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] registerAspectComponents error:" + ex, module);
            throw new Exception(ex);
        }
    }

    public void registerUserService() throws Exception {
        Debug.logVerbose("[JdonFramework] note: registe user pojoservice ", module);
        try {
            TargetMetaDefXmlLoader targetMetaDefXmlLoader = (TargetMetaDefXmlLoader)this.containerWrapper.lookup("targetMetaDefLoader");
            targetMetaDefXmlLoader.loadXML();
            TargetMetaDefHolder targetMetaDefHolder = (TargetMetaDefHolder)this.containerWrapper.lookup("targetMetaDefHolder");
            if (targetMetaDefHolder == null) {
                return;
            }
            Map<String, TargetMetaDef> metaDefs = targetMetaDefHolder.loadMetaDefs();
            for (String name : metaDefs.keySet()) {
                TargetMetaDef tgm = metaDefs.get(name);
                if (tgm.isEJB()) continue;
                this.xmlcontainerRegistry.registerPOJOTargetMetaDef((POJOTargetMetaDef)tgm);
            }
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] registerUserService error:" + ex, module);
            throw new Exception(ex);
        }
    }

    public void startApp() {
        StartablecomponentsRegistry scr = (StartablecomponentsRegistry)this.containerWrapper.lookup("startablecomponentsRegistry");
        scr.startStartableComponents(this.containerWrapper);
    }

    public void stopApp() {
        StartablecomponentsRegistry scr = (StartablecomponentsRegistry)this.containerWrapper.lookup("startablecomponentsRegistry");
        scr.stopStartableComponents(this.containerWrapper);
    }

    public synchronized void setKernelStartup(boolean startup) {
        this.startup = startup;
    }

    public boolean isKernelStartup() {
        return this.startup;
    }

    public void doAfterStarted() throws Exception {
    }
}

