/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.config;

import com.jdon.container.config.ComponentMetaDef;
import com.jdon.controller.config.XmlParser;
import com.jdon.util.Debug;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public class ContainerComponentsXmlLoader
extends XmlParser {
    public static final String module = ContainerComponentsXmlLoader.class.getName();

    public void parse(Element root, Map mps) throws Exception {
        List components = root.getChildren("component");
        Debug.logVerbose("[JdonFramework] found component size:" + components.size(), module);
        for (Element component : components) {
            String name = component.getAttributeValue("name");
            String className = component.getAttributeValue("class");
            List mappings = component.getChildren("constructor");
            String[] constructors = null;
            if (mappings != null && mappings.size() != 0) {
                constructors = new String[mappings.size()];
                int j = 0;
                for (Element constructor : mappings) {
                    String value = constructor.getAttributeValue("value");
                    Debug.logVerbose("[JdonFramework] component constructor=" + value, module);
                    constructors[j] = value;
                    ++j;
                }
            }
            ComponentMetaDef componentMetaDef = constructors != null ? new ComponentMetaDef(name, className, constructors) : new ComponentMetaDef(name, className);
            mps.put(name, componentMetaDef);
        }
    }
}

