/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.visitor.http;

import com.jdon.container.access.TargetMetaRequest;
import com.jdon.container.access.TargetMetaRequestsHolder;
import com.jdon.container.visitor.ComponentVisitor;
import com.jdon.container.visitor.ComponentsboxsInSession;
import com.jdon.container.visitor.data.SessionContext;
import com.jdon.container.visitor.http.HttpSessionVisitorFactorySetup;
import com.jdon.util.Debug;
import java.io.Serializable;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class HttpSessionProxyComponentVisitor
implements ComponentVisitor,
HttpSessionBindingListener,
Serializable {
    private static final long serialVersionUID = 5064552004049128373L;
    private static final String module = HttpSessionProxyComponentVisitor.class.getName();
    private final ComponentsboxsInSession componentsboxsInSession;
    private ComponentVisitor componentVisitor;
    private TargetMetaRequestsHolder targetMetaRequestsHolder;
    private final boolean dynamiceProxyisCached;

    public HttpSessionProxyComponentVisitor(ComponentVisitor componentVisitor, TargetMetaRequestsHolder targetMetaRequestsHolder, HttpSessionVisitorFactorySetup httpSessionVisitorFactorySetup) {
        this.componentVisitor = componentVisitor;
        this.targetMetaRequestsHolder = targetMetaRequestsHolder;
        this.componentsboxsInSession = new ComponentsboxsInSession(httpSessionVisitorFactorySetup);
        this.dynamiceProxyisCached = httpSessionVisitorFactorySetup.isDynamiceProxyisCached();
    }

    public void valueBound(HttpSessionBindingEvent event) {
        Debug.logVerbose("[JdonFramework] valueBound active, sessionId :" + event.getSession().getId(), module);
        this.componentsboxsInSession.clear();
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        String sessionId = event.getSession().getId();
        Debug.logVerbose("[JdonFramework] unvalueBound active, sessionId :" + sessionId, module);
        Debug.logVerbose("[JdonFramework] unvalueUnbound active, componentsboxs size" + this.componentsboxsInSession.size(), module);
        this.componentsboxsInSession.clear();
        if (this.targetMetaRequestsHolder != null) {
            this.targetMetaRequestsHolder.clear();
        }
        this.targetMetaRequestsHolder = null;
        this.componentVisitor = null;
    }

    public Object visit() {
        Object o = null;
        try {
            TargetMetaRequest targetMetaRequest = this.targetMetaRequestsHolder.getTargetMetaRequest();
            StringBuilder sb = new StringBuilder(targetMetaRequest.getTargetMetaDef().getCacheKey());
            sb.append(targetMetaRequest.getVisitableName());
            Debug.logVerbose("[JdonFramework] get the optimized instance for the key " + sb.toString(), module);
            o = this.componentsboxsInSession.get(sb.toString());
            if (o == null) {
                Debug.logVerbose("[JdonFramework] first time visit: " + targetMetaRequest.getTargetMetaDef().getClassName(), module);
                o = this.componentVisitor.visit();
                if (this.dynamiceProxyisCached) {
                    this.componentsboxsInSession.add(sb.toString(), o);
                }
            }
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework]visit error: " + e);
        }
        return o;
    }

    public SessionContext createSessionContext() {
        SessionContext sessionContext = (SessionContext)this.componentsboxsInSession.get(SessionContext.NAME);
        if (sessionContext == null) {
            TargetMetaRequest targetMetaRequest = this.targetMetaRequestsHolder.getTargetMetaRequest();
            Debug.logVerbose("[JdonFramework] first time visit sessionContext: " + targetMetaRequest.getVisitableName(), module);
            sessionContext = this.componentVisitor.createSessionContext();
            this.componentsboxsInSession.add(SessionContext.NAME, sessionContext);
        }
        return sessionContext;
    }

    public void removeObjects() {
    }
}

