/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.domain.message;

import com.jdon.async.disruptor.EventDisruptor;
import com.jdon.domain.message.DomainEventHandler;
import com.jdon.domain.message.consumer.ModelConsumerMethodHolder;
import com.jdon.util.Debug;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainCommandDispatchHandler
implements DomainEventHandler<EventDisruptor> {
    public static final String module = DomainCommandDispatchHandler.class.getName();
    private ModelConsumerMethodHolder modelConsumerMethodHolder;
    private static final Map<Class<?>, Object> defaultValues = new HashMap();

    public DomainCommandDispatchHandler(ModelConsumerMethodHolder modelConsumerMethodHolder) {
        this.modelConsumerMethodHolder = modelConsumerMethodHolder;
    }

    @Override
    public void onEvent(EventDisruptor event, boolean endOfBatch) throws Exception {
        try {
            Object parameter;
            Method method = this.modelConsumerMethodHolder.getConsumerMethodHolder().getMethod();
            Object model = event.getDomainMessage().getDestination();
            if (model == null) {
                Debug.logError("[Jdonframework]Destination that will be sent is null ", module);
                return;
            }
            Class<?>[] pTypes = method.getParameterTypes();
            if (pTypes.length == 0) {
                method.invoke(model, new Object[0]);
            }
            if ((parameter = event.getDomainMessage().getEventSource()) == null) {
                Debug.logError("[Jdonframework]the publisher method with @Send need return type" + pTypes[0].getName(), module);
                return;
            }
            Object[] parameters = new Object[pTypes.length];
            int i = 0;
            for (Class<?> pType : pTypes) {
                if (pType.isAssignableFrom(parameter.getClass())) {
                    parameters[i] = parameter;
                } else if (!pType.isPrimitive()) {
                    try {
                        parameters[i] = pType.newInstance();
                    }
                    catch (Exception e) {
                        Debug.logError("[Jdonframework] " + pType.getName() + " no default construtor :" + e, module);
                        e.printStackTrace();
                    }
                } else {
                    parameters[i] = defaultValues.get(pType);
                }
                ++i;
            }
            Object eventResult = method.invoke(model, parameters);
            event.getDomainMessage().setEventResult(eventResult);
        }
        catch (Exception e) {
            Debug.logError("[Jdonframework]" + this.modelConsumerMethodHolder.getConsumerMethodHolder().getClassName() + " method with @onCommand  happended error: " + e, module);
        }
    }

    static {
        defaultValues.put(String.class, "");
        defaultValues.put(Integer.class, 0);
        defaultValues.put(Integer.TYPE, 0);
        defaultValues.put(Long.class, 0L);
        defaultValues.put(Long.TYPE, 0L);
        defaultValues.put(Character.class, Character.valueOf('\u0000'));
        defaultValues.put(Character.TYPE, Character.valueOf('\u0000'));
    }
}

