/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.util;

import com.jdon.util.PropsUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Debug {
    public static final String LOG = "log.level";
    public static final String LOG4J = "log.log4j";
    public static final String SETUPNAME = "setup";
    public static final String SETUPVALUE = "true";
    public static boolean useLog4J = false;
    public static DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
    private static final PropsUtil propsUtil = new PropsUtil("log.xml");
    public static final int ALWAYS = 0;
    public static final int VERBOSE = 1;
    public static final int TIMING = 2;
    public static final int INFO = 3;
    public static final int IMPORTANT = 4;
    public static final int WARNING = 5;
    public static final int ERROR = 6;
    public static final int FATAL = 7;
    public static int conf_level = -1;
    public static final String[] levels = new String[]{"Always", "Verbose", "Timing", "Info", "Important", "Warning", "Error", "Fatal"};
    public static final String[] levelProps = new String[]{"", "print.verbose", "print.timing", "print.info", "print.important", "print.warning", "print.error", "print.fatal"};
    public static final Level[] levelObjs = new Level[]{Level.INFO, Level.DEBUG, Level.DEBUG, Level.INFO, Level.INFO, Level.WARN, Level.ERROR, Level.FATAL};
    protected static PrintStream printStream = System.out;
    protected static PrintWriter printWriter = new PrintWriter(printStream);

    public static PrintStream getPrintStream() {
        return printStream;
    }

    public static void setPrintStream(PrintStream printStream) {
        Debug.printStream = printStream;
        printWriter = new PrintWriter(printStream);
    }

    public static PrintWriter getPrintWriter() {
        return printWriter;
    }

    public static Logger getLogger(String module) {
        if (module != null && module.length() > 0) {
            return LogManager.getLogger((String)module);
        }
        return LogManager.getLogger(Debug.class);
    }

    public static void log(int level, Throwable t, String msg, String module) {
        Debug.log(level, t, msg, module, "com.jdon.util.Debug");
    }

    private static void log(int level, Throwable t, String msg, String module, String callingClass) {
        if (level >= conf_level) {
            if (useLog4J) {
                Logger logger = Debug.getLogger(module);
                if (logger.isDebugEnabled()) {
                    logger.debug(msg, t);
                } else if (logger.isErrorEnabled()) {
                    logger.error(msg, t);
                } else if (logger.isInfoEnabled()) {
                    logger.info(msg, t);
                } else if (logger.isWarnEnabled()) {
                    logger.warn(msg, t);
                } else if (logger.isFatalEnabled()) {
                    logger.fatal(msg, t);
                } else if (logger.isTraceEnabled()) {
                    logger.trace(msg, t);
                }
            } else {
                StringBuilder prefixBuf = new StringBuilder();
                prefixBuf.append(dateFormat.format(new Date()));
                prefixBuf.append(" [Debug");
                if (module != null) {
                    prefixBuf.append(":");
                    prefixBuf.append(module);
                }
                prefixBuf.append(":");
                prefixBuf.append(levels[level]);
                prefixBuf.append("] ");
                if (msg != null) {
                    Debug.getPrintStream().print(prefixBuf.toString());
                    Debug.getPrintStream().println(msg);
                }
                if (t != null) {
                    Debug.getPrintStream().print(prefixBuf.toString());
                    Debug.getPrintStream().println("Received throwable:");
                    t.printStackTrace(Debug.getPrintStream());
                }
            }
        }
    }

    public static boolean isOn(int level) {
        return level == 0;
    }

    public static void log(String msg) {
        Debug.log(0, null, msg, null);
    }

    public static void log(String msg, String module) {
        Debug.log(0, null, msg, module);
    }

    public static void log(Throwable t) {
        Debug.log(0, t, null, null);
    }

    public static void log(Throwable t, String msg) {
        Debug.log(0, t, msg, null);
    }

    public static void log(Throwable t, String msg, String module) {
        Debug.log(0, t, msg, module);
    }

    public static boolean verboseOn() {
        return Debug.isOn(1);
    }

    public static void logVerbose(String msg) {
        Debug.log(1, null, msg, null);
    }

    public static void logVerbose(String msg, String module) {
        Debug.log(1, null, msg, module);
    }

    public static void logVerbose(Throwable t) {
        Debug.log(1, t, null, null);
    }

    public static void logVerbose(Throwable t, String msg) {
        Debug.log(1, t, msg, null);
    }

    public static void logVerbose(Throwable t, String msg, String module) {
        Debug.log(1, t, msg, module);
    }

    public static boolean timingOn() {
        return Debug.isOn(2);
    }

    public static void logTiming(String msg) {
        Debug.log(2, null, msg, null);
    }

    public static void logTiming(String msg, String module) {
        Debug.log(2, null, msg, module);
    }

    public static void logTiming(Throwable t) {
        Debug.log(2, t, null, null);
    }

    public static void logTiming(Throwable t, String msg) {
        Debug.log(2, t, msg, null);
    }

    public static void logTiming(Throwable t, String msg, String module) {
        Debug.log(2, t, msg, module);
    }

    public static boolean infoOn() {
        return Debug.isOn(3);
    }

    public static void logInfo(String msg) {
        Debug.log(3, null, msg, null);
    }

    public static void logInfo(String msg, String module) {
        Debug.log(3, null, msg, module);
    }

    public static void logInfo(Throwable t) {
        Debug.log(3, t, null, null);
    }

    public static void logInfo(Throwable t, String msg) {
        Debug.log(3, t, msg, null);
    }

    public static void logInfo(Throwable t, String msg, String module) {
        Debug.log(3, t, msg, module);
    }

    public static boolean importantOn() {
        return Debug.isOn(4);
    }

    public static void logImportant(String msg) {
        Debug.log(4, null, msg, null);
    }

    public static void logImportant(String msg, String module) {
        Debug.log(4, null, msg, module);
    }

    public static void logImportant(Throwable t) {
        Debug.log(4, t, null, null);
    }

    public static void logImportant(Throwable t, String msg) {
        Debug.log(4, t, msg, null);
    }

    public static void logImportant(Throwable t, String msg, String module) {
        Debug.log(4, t, msg, module);
    }

    public static boolean warningOn() {
        return Debug.isOn(5);
    }

    public static void logWarning(String msg) {
        Debug.log(5, null, msg, null);
    }

    public static void logWarning(String msg, String module) {
        Debug.log(5, null, msg, module);
    }

    public static void logWarning(Throwable t) {
        Debug.log(5, t, null, null);
    }

    public static void logWarning(Throwable t, String msg) {
        Debug.log(5, t, msg, null);
    }

    public static void logWarning(Throwable t, String msg, String module) {
        Debug.log(5, t, msg, module);
    }

    public static boolean errorOn() {
        return Debug.isOn(6);
    }

    public static void logError(String msg) {
        Debug.log(6, null, msg, null);
    }

    public static void logError(String msg, String module) {
        Debug.log(6, null, msg, module);
    }

    public static void logError(Throwable t) {
        Debug.log(6, t, null, null);
    }

    public static void logError(Throwable t, String msg) {
        Debug.log(6, t, msg, null);
    }

    public static void logError(Throwable t, String msg, String module) {
        Debug.log(6, t, msg, module);
    }

    public static boolean fatalOn() {
        return Debug.isOn(7);
    }

    public static void logFatal(String msg) {
        Debug.log(7, null, msg, null);
    }

    public static void logFatal(String msg, String module) {
        Debug.log(7, null, msg, module);
    }

    public static void logFatal(Throwable t) {
        Debug.log(7, t, null, null);
    }

    public static void logFatal(Throwable t, String msg) {
        Debug.log(7, t, msg, null);
    }

    public static void logFatal(Throwable t, String msg, String module) {
        Debug.log(7, t, msg, module);
    }

    static {
        try {
            String log4jStrs;
            String levelStrs = propsUtil.getProperty(LOG);
            if (levelStrs != null) {
                conf_level = Integer.parseInt(levelStrs);
            }
            if ((log4jStrs = propsUtil.getProperty(LOG4J)) != null && log4jStrs.equalsIgnoreCase(SETUPVALUE)) {
                useLog4J = true;
            }
        }
        catch (Exception e) {
            System.err.print("getLogLevel e");
            conf_level = 1;
            useLog4J = false;
        }
    }
}

