/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.aop.interceptor;

import com.jdon.container.pico.Startable;
import com.jdon.controller.model.ModelUtil;
import com.jdon.domain.model.cache.ModelKey;
import com.jdon.domain.model.cache.ModelManager;
import com.jdon.util.Debug;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class CacheInterceptor
implements MethodInterceptor,
Startable {
    private static final String module = CacheInterceptor.class.getName();
    public String match_MethodName = "get";
    private ModelManager modelManager;
    private Set isModelCache = new HashSet();

    public CacheInterceptor(ModelManager modelManager) {
        this.modelManager = modelManager;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!this.methodMatchsModelGET(method)) {
            return invocation.proceed();
        }
        Debug.logVerbose("[JdonFramework] enter cacheInteceptor method:" + method.getName(), module);
        Class<?> modelClass = method.getReturnType();
        String dataKey = this.getArguments(invocation);
        if (dataKey == null || modelClass == null) {
            return invocation.proceed();
        }
        try {
            ModelKey modelKey = new ModelKey((Object)dataKey, modelClass);
            return this.getModelofCache(modelKey, invocation);
        }
        catch (Exception e) {
            Debug.logError("[JdonFramework]CacheInterceptor Exception error:" + e + " method:" + method.getName() + " return class:" + modelClass + " dataKey:" + dataKey, module);
            return invocation.proceed();
        }
    }

    public Object getModelofCache(ModelKey modelKey, MethodInvocation invocation) throws Throwable {
        Object existmodel = this.modelManager.getCache(modelKey);
        Object newmodel = null;
        if (existmodel == null && (newmodel = invocation.proceed()) != null && invocation.getMethod().getReturnType().isAssignableFrom(newmodel.getClass())) {
            Debug.logVerbose("[JdonFramework] save to cache", module);
            existmodel = this.modelManager.addCache(modelKey, newmodel);
        }
        return existmodel != null ? existmodel : newmodel;
    }

    private boolean methodMatchsModelGET(Method method) {
        boolean condition = false;
        try {
            if (this.isModelCache.contains(method)) {
                condition = true;
                return condition;
            }
            String mehtodName = method.getName();
            if (method.getReturnType() == null) {
                return condition;
            }
            Class<?> returnClass = method.getReturnType();
            if (returnClass.getSuperclass() == null) {
                return condition;
            }
            Debug.logVerbose("[JdonFramework]methodMatchsModelGET: returnClassName = " + returnClass.getName(), module);
            if (ModelUtil.isModel(returnClass) && mehtodName.indexOf(this.match_MethodName) != -1) {
                condition = true;
                this.isModelCache.add(method);
            }
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework]Exception error:" + ex, module);
        }
        catch (Throwable the) {
            Debug.logError("[JdonFramework]Throwable error:" + the, module);
        }
        return condition;
    }

    public String getArguments(MethodInvocation invocation) {
        try {
            Object[] args = invocation.getArguments();
            if (args == null) {
                return null;
            }
            if (args.length != 1) {
                return null;
            }
            if (args[0] == null) {
                return null;
            }
            return args[0].toString();
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] method:" + invocation.getMethod().getName() + "  " + ex, module);
            return null;
        }
    }

    public String getMatch_MethodName() {
        return this.match_MethodName;
    }

    public void start() {
    }

    public void stop() {
        this.isModelCache.clear();
        this.isModelCache = null;
        this.modelManager = null;
    }
}

