/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.aop.interceptor;

import com.jdon.aop.reflection.ProxyMethodInvocation;
import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.bussinessproxy.target.TargetServiceFactory;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.access.TargetMetaRequestsHolder;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.container.pico.Startable;
import com.jdon.controller.cache.InstanceCache;
import com.jdon.controller.pool.CommonsPoolAdapter;
import com.jdon.controller.pool.CommonsPoolFactory;
import com.jdon.controller.pool.PoolConfigure;
import com.jdon.controller.pool.Poolable;
import com.jdon.util.Debug;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class PoolInterceptor
implements MethodInterceptor,
Startable {
    private static final String module = PoolInterceptor.class.getName();
    private ConcurrentMap poolFactorys;
    private TargetServiceFactory targetServiceFactory;
    private ContainerCallback containerCallback;
    private PoolConfigure poolConfigure;
    private List isPoolableCache = new CopyOnWriteArrayList();
    private Set unPoolableCache = new HashSet();
    private TargetMetaRequestsHolder targetMetaRequestsHolder;

    public PoolInterceptor(TargetServiceFactory targetServiceFactory, TargetMetaRequestsHolder targetMetaRequestsHolder, ContainerCallback containerCallback, PoolConfigure poolConfigure) {
        this.targetServiceFactory = targetServiceFactory;
        this.targetMetaRequestsHolder = targetMetaRequestsHolder;
        this.containerCallback = containerCallback;
        this.poolConfigure = poolConfigure;
        this.poolFactorys = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        ProxyMethodInvocation proxyMethodInvocation = (ProxyMethodInvocation)invocation;
        TargetMetaDef targetMetaDef = this.targetMetaRequestsHolder.getTargetMetaRequest().getTargetMetaDef();
        if (targetMetaDef.isEJB()) {
            return invocation.proceed();
        }
        if (!this.isPoolabe(targetMetaDef)) {
            return invocation.proceed();
        }
        Debug.logVerbose("[JdonFramework] enter PoolInterceptor", module);
        CommonsPoolFactory commonsPoolFactory = this.getCommonsPoolFactoryCache(targetMetaDef);
        CommonsPoolAdapter pool = commonsPoolFactory.getPool();
        Object poa = null;
        Object result = null;
        try {
            poa = pool.acquirePoolable();
            Debug.logVerbose("[JdonFramework] borrow a object:" + targetMetaDef.getClassName() + " id:" + poa.hashCode() + " from pool", module);
            Debug.logVerbose("[JdonFramework]pool state: active=" + pool.getNumActive() + " free=" + pool.getNumIdle(), module);
            proxyMethodInvocation.setThis(poa);
            result = invocation.proceed();
        }
        catch (Exception ex) {
            Debug.logError(ex, module);
        }
        finally {
            if (poa != null) {
                pool.releasePoolable(poa);
                Debug.logVerbose("[JdonFramework] realease a object:" + targetMetaDef.getClassName() + " to pool", module);
            }
        }
        return result;
    }

    private CommonsPoolFactory getCommonsPoolFactoryCache(TargetMetaDef targetMetaDef) {
        CommonsPoolFactory commonsPoolFactoryExist = (CommonsPoolFactory)this.poolFactorys.get(targetMetaDef.getCacheKey());
        CommonsPoolFactory commonsPoolFactoryNew = null;
        if (commonsPoolFactoryExist == null) {
            commonsPoolFactoryNew = this.getCommonsPoolFactory(targetMetaDef);
            commonsPoolFactoryExist = this.poolFactorys.putIfAbsent(targetMetaDef.getCacheKey(), commonsPoolFactoryNew);
        }
        return commonsPoolFactoryExist != null ? commonsPoolFactoryExist : commonsPoolFactoryNew;
    }

    private CommonsPoolFactory getCommonsPoolFactory(TargetMetaDef targetMetaDef) {
        try {
            ContainerWrapper containerWrapper = this.containerCallback.getContainerWrapper();
            InstanceCache instanceCache = (InstanceCache)containerWrapper.lookup("instanceCache");
            String key = targetMetaDef.getCacheKey() + " CommonsPoolFactory";
            CommonsPoolFactory commonsPoolFactoryExist = (CommonsPoolFactory)instanceCache.get(key);
            CommonsPoolFactory commonsPoolFactoryNew = null;
            if (commonsPoolFactoryExist == null) {
                Debug.logVerbose("[JdonFramework] first time call commonsPoolFactory\uff0c create it:" + key, module);
                commonsPoolFactoryNew = this.create(this.targetServiceFactory, this.poolConfigure.getMaxPoolSize());
                commonsPoolFactoryExist = (CommonsPoolFactory)instanceCache.putIfAbsent(key, commonsPoolFactoryNew);
            }
            return commonsPoolFactoryExist != null ? commonsPoolFactoryExist : commonsPoolFactoryNew;
        }
        catch (Exception ex) {
            Debug.logError(ex, module);
            return null;
        }
    }

    public CommonsPoolFactory create(TargetServiceFactory targetServiceFactory, String maxSize) {
        CommonsPoolFactory commonsPoolFactory = new CommonsPoolFactory(targetServiceFactory, maxSize);
        GenericObjectPool apachePool = new GenericObjectPool((PoolableObjectFactory)commonsPoolFactory);
        CommonsPoolAdapter pool = new CommonsPoolAdapter(apachePool);
        if (maxSize == null) {
            Debug.logError("[JdonFramework] not set pool's max size", module);
        } else {
            int maxInt = Integer.parseInt(maxSize);
            pool.setMaxPoolSize(maxInt);
        }
        commonsPoolFactory.setPool(pool);
        return commonsPoolFactory;
    }

    public boolean isPoolabe(TargetMetaDef targetMetaDef) {
        boolean found = false;
        if (this.isPoolableCache.contains(targetMetaDef.getName())) {
            found = true;
        } else if (!this.unPoolableCache.contains(targetMetaDef.getName())) {
            Debug.logVerbose("[JdonFramework] check if it is a Poolable", module);
            ContainerWrapper containerWrapper = this.containerCallback.getContainerWrapper();
            Class thisCLass = containerWrapper.getComponentClass(targetMetaDef.getName());
            if (Poolable.class.isAssignableFrom(thisCLass) || thisCLass.isAnnotationPresent(com.jdon.annotation.intercept.Poolable.class)) {
                found = true;
                this.isPoolableCache.add(targetMetaDef.getName());
            } else {
                this.unPoolableCache.add(targetMetaDef.getName());
            }
        }
        return found;
    }

    public void start() {
    }

    public void stop() {
        ContainerWrapper containerWrapper;
        InstanceCache instanceCache;
        if (this.isPoolableCache != null) {
            this.isPoolableCache.clear();
            this.unPoolableCache.clear();
            this.poolFactorys.clear();
            this.targetMetaRequestsHolder.clear();
        }
        if ((instanceCache = (InstanceCache)(containerWrapper = this.containerCallback.getContainerWrapper()).lookup("instanceCache")) != null) {
            for (Object key : instanceCache.keys()) {
                if (!(key instanceof String)) continue;
                CommonsPoolFactory commonsPoolFactory = (CommonsPoolFactory)instanceCache.get((String)key);
                commonsPoolFactory.getPool().close();
            }
        }
        this.containerCallback = null;
        this.isPoolableCache = null;
        this.poolConfigure = null;
        this.poolFactorys = null;
        this.targetMetaRequestsHolder = null;
        this.targetServiceFactory = null;
        this.unPoolableCache = null;
    }
}

