/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.aop.interceptor;

import com.jdon.aop.reflection.ProxyMethodInvocation;
import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.access.TargetMetaRequest;
import com.jdon.container.access.TargetMetaRequestsHolder;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.container.pico.Startable;
import com.jdon.container.visitor.ComponentVisitor;
import com.jdon.controller.service.Stateful;
import com.jdon.util.Debug;
import java.util.HashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class StatefulInterceptor
implements MethodInterceptor,
Startable {
    private static final String module = StatefulInterceptor.class.getName();
    private final Set isStatefulCache = new HashSet();
    private final Set unStatefulCache = new HashSet();
    private final ContainerCallback containerCallback;
    private final TargetMetaRequestsHolder targetMetaRequestsHolder;

    public StatefulInterceptor(ContainerCallback containerCallback, TargetMetaRequestsHolder targetMetaRequestsHolder) {
        this.containerCallback = containerCallback;
        this.targetMetaRequestsHolder = targetMetaRequestsHolder;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        ProxyMethodInvocation pmi = (ProxyMethodInvocation)invocation;
        TargetMetaRequest targetMetaRequest = this.targetMetaRequestsHolder.getTargetMetaRequest();
        TargetMetaDef targetMetaDef = targetMetaRequest.getTargetMetaDef();
        if (targetMetaDef.isEJB()) {
            return invocation.proceed();
        }
        if (!this.isStateful(targetMetaDef)) {
            return invocation.proceed();
        }
        Debug.logVerbose("[JdonFramework] enter StatefulInterceptor", module);
        Object result = null;
        try {
            ComponentVisitor cm = targetMetaRequest.getComponentVisitor();
            targetMetaRequest.setVisitableName("targetServiceFactoryVisitable");
            Debug.logVerbose("targetServiceFactoryVisitable in action (Stateful)", module);
            Object targetObjRef = cm.visit();
            pmi.setThis(targetObjRef);
            result = invocation.proceed();
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework]StatefulInterceptor error: " + ex, module);
        }
        return result;
    }

    public boolean isStateful(TargetMetaDef targetMetaDef) {
        boolean found = false;
        if (this.isStatefulCache.contains(targetMetaDef.getName())) {
            found = true;
        } else if (!this.unStatefulCache.contains(targetMetaDef.getName())) {
            Debug.logVerbose("[JdonFramework] check if it is a isStateful", module);
            ContainerWrapper containerWrapper = this.containerCallback.getContainerWrapper();
            Class thisCLass = containerWrapper.getComponentClass(targetMetaDef.getName());
            if (Stateful.class.isAssignableFrom(thisCLass) || thisCLass.isAnnotationPresent(com.jdon.annotation.intercept.Stateful.class)) {
                found = true;
                this.isStatefulCache.add(targetMetaDef.getName());
            } else {
                this.unStatefulCache.add(targetMetaDef.getName());
            }
        }
        return found;
    }

    public void start() {
    }

    public void stop() {
        this.isStatefulCache.clear();
        this.unStatefulCache.clear();
    }
}

