/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.async.disruptor;

import com.jdon.async.disruptor.EventResultDisruptor;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueEventProcessor {
    protected final RingBuffer<EventResultDisruptor> ringBuffer;
    private long waitAtSequence = 0L;

    public ValueEventProcessor(RingBuffer<EventResultDisruptor> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    public void send(Object result) {
        this.waitAtSequence = this.ringBuffer.next();
        EventResultDisruptor ve = (EventResultDisruptor)this.ringBuffer.get(this.waitAtSequence);
        ve.setValue(result);
        this.ringBuffer.publish(this.waitAtSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventResultDisruptor waitFor() {
        SequenceBarrier barrier = this.ringBuffer.newBarrier(new Sequence[0]);
        try {
            long a = barrier.waitFor(this.waitAtSequence);
            if (this.ringBuffer != null) {
                EventResultDisruptor eventResultDisruptor = (EventResultDisruptor)this.ringBuffer.get(a);
                return eventResultDisruptor;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            barrier.alert();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventResultDisruptor waitForBlocking() {
        SequenceBarrier barrier = this.ringBuffer.newBarrier(new Sequence[0]);
        try {
            long a = barrier.waitFor(this.waitAtSequence);
            if (this.ringBuffer != null) {
                EventResultDisruptor eventResultDisruptor = (EventResultDisruptor)this.ringBuffer.get(a);
                return eventResultDisruptor;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            barrier.alert();
        }
        return null;
    }

    public long getWaitAtSequence() {
        return this.waitAtSequence;
    }

    public void setWaitAtSequence(long waitAtSequence) {
        this.waitAtSequence = waitAtSequence;
    }

    public void clear() {
    }

    public RingBuffer<EventResultDisruptor> getRingBuffer() {
        return this.ringBuffer;
    }
}

