/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.async.disruptor.pool;

import com.jdon.async.disruptor.DisruptorForCommandFactory;
import com.jdon.async.disruptor.pool.DisruptorPoolFactory;
import com.jdon.util.Debug;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.picocontainer.Startable;

public class DisruptorCommandPoolFactory
implements Startable {
    public static final String module = DisruptorPoolFactory.class.getName();
    private DisruptorForCommandFactory disruptorForCommandFactory;
    private ConcurrentHashMap<String, Disruptor> topicDisruptors;
    private ScheduledExecutorService scheduExecStatic = Executors.newScheduledThreadPool(1);

    public DisruptorCommandPoolFactory() {
        this.topicDisruptors = new ConcurrentHashMap();
    }

    public void start() {
        Runnable task = new Runnable(){

            public void run() {
                DisruptorCommandPoolFactory.this.stopDisruptor();
            }
        };
        this.scheduExecStatic.scheduleAtFixedRate(task, 3600L, 3600L, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.topicDisruptors != null) {
            this.stopDisruptor();
            this.topicDisruptors.clear();
            this.topicDisruptors = null;
        }
        this.scheduExecStatic.shutdownNow();
    }

    private void stopDisruptor() {
        HashMap<String, Disruptor> mydisruptors = new HashMap<String, Disruptor>(this.topicDisruptors);
        this.topicDisruptors.clear();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        for (String topic : mydisruptors.keySet()) {
            Disruptor disruptor = (Disruptor)mydisruptors.get(topic);
            try {
                disruptor.halt();
            }
            catch (Exception exception) {}
        }
        mydisruptors.clear();
    }

    public Disruptor getDisruptor(String topic, Object target) {
        Disruptor disruptor = this.topicDisruptors.get(topic + target);
        if (disruptor == null) {
            disruptor = this.disruptorForCommandFactory.createDisruptor(topic);
            if (disruptor == null) {
                Debug.logWarning("not create disruptor for " + topic, module);
                return null;
            }
            Disruptor disruptorOLd = this.topicDisruptors.putIfAbsent(topic + target, disruptor);
            if (disruptorOLd != null) {
                disruptor = disruptorOLd;
            }
        }
        return disruptor;
    }

    public DisruptorForCommandFactory getDisruptorForCommandFactory() {
        return this.disruptorForCommandFactory;
    }

    public void setDisruptorForCommandFactory(DisruptorForCommandFactory disruptorForCommandFactory) {
        this.disruptorForCommandFactory = disruptorForCommandFactory;
    }
}

