/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.cache;

import com.jdon.cache.UtilCache;
import com.jdon.container.pico.Startable;
import com.jdon.controller.cache.Cache;
import com.jdon.util.PropsUtil;
import java.util.Collection;

public class LRUCache
implements Cache,
Startable {
    private final UtilCache cache;

    public LRUCache(String configFileName) {
        PropsUtil propsUtil = new PropsUtil(configFileName);
        this.cache = new UtilCache(propsUtil);
    }

    public Object get(Object key) {
        return this.cache.get(key);
    }

    public void put(Object key, Object value) {
        this.cache.put(key, value);
    }

    public synchronized Object putIfAbsent(Object key, Object value) {
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, value);
        }
        return this.cache.get(key);
    }

    public void remove(Object key) {
        this.cache.remove(key);
    }

    public long size() {
        return this.cache.size();
    }

    public void clear() {
        this.cache.clearAllCaches();
    }

    public boolean contain(Object key) {
        return this.cache.containsKey(key);
    }

    public Collection keySet() {
        return this.cache.keySet();
    }

    public void stop() {
        this.cache.stop();
    }

    public void start() {
    }

    public long getCacheHits() {
        return this.cache.getHitCount();
    }

    public long getCacheMisses() {
        return this.cache.getMissCount();
    }
}

