/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.components.encache;

import com.jdon.components.encache.EhcacheConf;
import com.jdon.container.pico.Startable;
import com.jdon.controller.cache.Cache;
import com.jdon.util.FileLocator;
import java.io.InputStream;
import java.util.Collection;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class EncacheProvider
implements Cache,
Startable {
    private CacheManager manager;
    private final EhcacheConf ehcacheConf;

    public EncacheProvider(EhcacheConf ehcacheConf) {
        this.ehcacheConf = ehcacheConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (this.manager == null) {
                FileLocator fileLocator = new FileLocator();
                InputStream pathCongfgName = fileLocator.getConfStream(this.ehcacheConf.getEhcacheConfFileName());
                this.manager = new CacheManager(pathCongfgName);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void stop() {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        cache.removeAll();
        this.manager.removeCache(this.ehcacheConf.getPredefinedCacheName());
        this.manager.removalAll();
        this.manager.clearAll();
        this.manager.shutdown();
        this.manager = null;
    }

    public Object get(Object key) {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        Element e = cache.get(key);
        if (e == null) {
            return null;
        }
        return e.getObjectValue();
    }

    public void put(Object key, Object value) {
        Element element = new Element(key, value);
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        cache.put(element);
    }

    public void remove(Object key) {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        cache.remove(key);
    }

    public long size() {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        return cache.getMemoryStoreSize();
    }

    public void clear() {
        if (this.manager != null) {
            net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
            cache.removeAll();
        }
    }

    public boolean contain(Object key) {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        return cache.isKeyInCache(key);
    }

    public Collection keySet() {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        return cache.getKeys();
    }

    public long getCacheHits() {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        return cache.getStatistics().getCacheHits();
    }

    public long getCacheMisses() {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        return cache.getStatistics().getCacheMisses();
    }

    public static void main(String[] args) throws Exception {
        EhcacheConf ehcacheConf = new EhcacheConf("jdon_ehcache.xml", "jdonCache");
        EncacheProvider encacheProvider = new EncacheProvider(ehcacheConf);
        encacheProvider.start();
        encacheProvider.put("key1", "value122");
        String value = (String)encacheProvider.get("key1");
        System.out.println("value=" + value);
        encacheProvider.remove("key1");
        value = (String)encacheProvider.get("key2");
        System.out.println("value2=" + value);
    }

    public synchronized Object putIfAbsent(Object key, Object value) {
        net.sf.ehcache.Cache cache = this.manager.getCache(this.ehcacheConf.getPredefinedCacheName());
        if (!cache.isKeyInCache(key)) {
            Element element = new Element(key, value);
            cache.put(element);
        }
        Element e = cache.get(key);
        return e.getObjectValue();
    }
}

