/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.components.guavacache;

import com.google.common.cache.CacheBuilder;
import com.jdon.components.guavacache.GuavaCacheConf;
import com.jdon.container.pico.Startable;
import com.jdon.controller.cache.Cache;
import java.util.Collection;

public class GuavaCacheProvider
implements Cache,
Startable {
    private com.google.common.cache.Cache<Object, Object> cache;
    private final GuavaCacheConf guavaCacheConf;

    public GuavaCacheProvider(GuavaCacheConf guavaCacheConf) {
        this.guavaCacheConf = guavaCacheConf;
    }

    public void start() {
        this.cache = CacheBuilder.newBuilder().maximumSize((long)this.guavaCacheConf.getMaximumSize()).build();
    }

    public void stop() {
        this.cache.cleanUp();
        this.cache.invalidateAll();
    }

    public Object get(Object key) {
        return this.cache.getIfPresent(key);
    }

    public void put(Object key, Object value) {
        this.cache.put(key, value);
    }

    public Object putIfAbsent(Object key, Object value) {
        return this.cache.asMap().putIfAbsent(key, value);
    }

    public void remove(Object key) {
        this.cache.invalidate(key);
    }

    public long size() {
        return this.cache.size();
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public boolean contain(Object key) {
        return this.get(key) != null;
    }

    public Collection keySet() {
        return this.cache.asMap().keySet();
    }

    public long getCacheHits() {
        return this.cache.stats().hitCount();
    }

    public long getCacheMisses() {
        return this.cache.stats().missCount();
    }
}

