/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.annotation;

import com.jdon.controller.context.AppContextWrapper;
import com.jdon.controller.context.web.ServletContextWrapper;
import com.jdon.util.Debug;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.scannotation.ClasspathUrlFinder;
import org.scannotation.WarUrlFinder;

public class AnnotationUtil {
    public static final String module = AnnotationUtil.class.getName();

    public static URL[] scanAnnotation(AppContextWrapper context) {
        ArrayList<URL> lists = new ArrayList<URL>();
        try {
            URL[] jdonurls;
            List libURls;
            ServletContextWrapper scw;
            URL classURl;
            URL[] urls = ClasspathUrlFinder.findClassPaths();
            if (!(context instanceof ServletContextWrapper)) {
                return urls;
            }
            if (urls != null) {
                lists.addAll(Arrays.asList(urls));
            }
            if ((classURl = WarUrlFinder.findWebInfClassesPath((ServletContext)(scw = (ServletContextWrapper)context).getServletContext())) != null) {
                lists.add(classURl);
            }
            if ((libURls = AnnotationUtil.findWebInfLibClasspaths(scw.getServletContext())) != null) {
                lists.addAll(libURls);
            }
            if ((jdonurls = ClasspathUrlFinder.findResourceBases((String)"com/jdon/container/annotation/AnnotationUtil.class")) != null) {
                lists.addAll(Arrays.asList(jdonurls));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lists.toArray(new URL[lists.size()]);
    }

    public static List findWebInfLibClasspaths(ServletContext servletContext) {
        ArrayList<URL> list = new ArrayList<URL>();
        Set libJars = servletContext.getResourcePaths("/WEB-INF/lib");
        if (libJars == null) {
            return null;
        }
        for (Object jar : libJars) {
            try {
                list.add(servletContext.getResource((String)jar));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }

    public static boolean methodParameterContainAnnotation(Method method, Class annotationClass) {
        boolean found = false;
        try {
            Annotation[][] parameterAnnotations;
            Annotation[][] annotationArray = parameterAnnotations = method.getParameterAnnotations();
            int n = annotationArray.length;
            block2: for (int i = 0; i < n; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = annotationArray[i]) {
                    if (!annotation.annotationType().isAssignableFrom(annotationClass)) continue;
                    found = true;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            Debug.logError("getInputparameter" + e, module);
        }
        return found;
    }
}

