/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.annotation.type;

import com.jdon.annotation.Model;
import com.jdon.annotation.model.OnCommand;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.annotation.AnnotationHolder;
import com.jdon.container.annotation.type.AnnotationScaner;
import com.jdon.container.annotation.type.Utils;
import com.jdon.controller.context.AppContextWrapper;
import com.jdon.domain.message.consumer.ConsumerMethodHolder;
import com.jdon.domain.message.consumer.ModelConsumerMethodHolder;
import com.jdon.util.ClassUtil;
import java.lang.reflect.Method;
import java.util.Set;

public class ModelConsumerLoader {
    public static final String TOPICNAME2 = "MEHTOD_TOPIC_COMMAND";
    AnnotationScaner annotationScaner;

    public ModelConsumerLoader(AnnotationScaner annotationScaner) {
        this.annotationScaner = annotationScaner;
    }

    public void loadAnnotationModels(AnnotationHolder annotationHolder, AppContextWrapper context, ContainerWrapper containerWrapper) {
        Set<String> classes = this.annotationScaner.getScannedAnnotations(context).get(Model.class.getName());
        if (classes == null) {
            return;
        }
        for (String className : classes) {
            Class cclass = Utils.createClass(className);
            this.loadMehtodAnnotations(cclass, containerWrapper);
        }
    }

    public void loadMehtodAnnotations(Class cclass, ContainerWrapper containerWrapper) {
        try {
            for (Method method : ClassUtil.getAllDecaredMethods(cclass)) {
                if (!method.isAnnotationPresent(OnCommand.class)) continue;
                this.addConsumerMethod(method, cclass, containerWrapper);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addConsumerMethod(Method method, Class cclass, ContainerWrapper containerWrapper) {
        OnCommand onCommand = method.getAnnotation(OnCommand.class);
        String consumerKey = TOPICNAME2 + onCommand.value();
        ModelConsumerMethodHolder modelConsumerMethodHolder = this.getContainerConsumers(consumerKey, containerWrapper);
        modelConsumerMethodHolder.setConsumerMethodHolder(new ConsumerMethodHolder(cclass.getName(), method));
    }

    public ModelConsumerMethodHolder getContainerConsumers(String topicKey, ContainerWrapper containerWrapper) {
        ModelConsumerMethodHolder modelConsumerMethodHolder = (ModelConsumerMethodHolder)containerWrapper.lookup(topicKey);
        if (modelConsumerMethodHolder == null) {
            modelConsumerMethodHolder = new ModelConsumerMethodHolder();
            containerWrapper.register(topicKey, modelConsumerMethodHolder);
        }
        return modelConsumerMethodHolder;
    }
}

