/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.container.builder;

import com.jdon.container.ContainerWrapper;
import com.jdon.container.builder.ContainerRegistryBuilder;
import com.jdon.container.builder.StartupException;
import com.jdon.util.Debug;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContainerDirector {
    public static final String module = ContainerDirector.class.getName();
    private static final Logger logger = LogManager.getLogger((String)"JdonFramework");
    private final ContainerRegistryBuilder cb;

    public ContainerDirector(ContainerRegistryBuilder cb) {
        this.cb = cb;
    }

    public synchronized void prepareAppRoot(String configureFileName) throws Exception {
        if (!this.cb.isKernelStartup()) {
            this.cb.registerAppRoot(configureFileName);
            logger.info(configureFileName + " is ready.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() throws StartupException {
        Debug.logVerbose("[JdonFramework] <======== JdonFramework beigin to startup =========>", module);
        if (!this.cb.isKernelStartup()) {
            ContainerRegistryBuilder containerRegistryBuilder = this.cb;
            synchronized (containerRegistryBuilder) {
                if (!this.cb.isKernelStartup()) {
                    try {
                        Debug.logVerbose("[JdonFramework] <------ register the basic components in container.xml ------> ", module);
                        this.cb.registerComponents();
                        ContainerWrapper cw = this.cb.getContainerWrapper();
                        Debug.logVerbose("[JdonFramework] <------ started micro container ------> ", module);
                        cw.start();
                        this.cb.setKernelStartup(true);
                        Debug.logVerbose("[JdonFramework] <------ register the pojo services in application's xml ------> ", module);
                        this.cb.registerUserService();
                        Debug.logVerbose("[JdonFramework] <------ register the aspect components in container.xml ------> ", module);
                        this.cb.registerAspectComponents();
                        this.cb.startApp();
                        this.cb.doAfterStarted();
                        logger.info("Jdon Framework started successfully! ");
                        cw.setStart(true);
                    }
                    catch (Exception ex) {
                        Debug.logError("[JdonFramework] startup container error: " + ex, module);
                        throw new StartupException();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws StartupException {
        Debug.logVerbose("[JdonFramework] <======== JdonFramework beigin to shutdown =========>", module);
        if (this.cb.isKernelStartup()) {
            ContainerRegistryBuilder containerRegistryBuilder = this.cb;
            synchronized (containerRegistryBuilder) {
                if (this.cb.isKernelStartup()) {
                    try {
                        ContainerWrapper cw = this.cb.getContainerWrapper();
                        this.cb.stopApp();
                        cw.stop();
                        cw.setStart(false);
                        this.cb.setKernelStartup(false);
                        logger.info("Jdon Framework shutdown successfully! ");
                    }
                    catch (Exception ex) {
                        Debug.logError("[JdonFramework] shutdown container error: " + ex, module);
                        throw new StartupException();
                    }
                }
            }
        }
    }
}

