/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.controller;

import com.jdon.bussinessproxy.TargetMetaDef;
import com.jdon.bussinessproxy.meta.MethodMetaArgs;
import com.jdon.container.ContainerWrapper;
import com.jdon.container.finder.ContainerFinderImp;
import com.jdon.controller.AppUtil;
import com.jdon.controller.context.RequestWrapper;
import com.jdon.controller.context.web.RequestWrapperFactory;
import com.jdon.controller.context.web.ServletContextWrapper;
import com.jdon.controller.service.Service;
import com.jdon.controller.service.ServiceFacade;
import com.jdon.controller.service.ServiceFactory;
import com.jdon.util.Debug;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class WebAppUtil {
    private static final String module = WebAppUtil.class.getName();
    private static final ContainerFinderImp scf = new ContainerFinderImp();

    public static Object getService(String name, HttpServletRequest request) {
        ServletContext sc = request.getSession().getServletContext();
        ServiceFacade serviceFacade = new ServiceFacade();
        ServiceFactory serviceFactory = serviceFacade.getServiceFactory(new ServletContextWrapper(sc));
        RequestWrapper requestW = RequestWrapperFactory.create(request);
        return serviceFactory.getService(name, requestW);
    }

    public static Object getService(String name, ServletContext sc) {
        ServletContextWrapper acw = new ServletContextWrapper(sc);
        ServiceFacade serviceFacade = new ServiceFacade();
        ServiceFactory serviceFactory = serviceFacade.getServiceFactory(acw);
        return serviceFactory.getService(name, acw);
    }

    public static Object getService(TargetMetaDef targetMetaDef, HttpServletRequest request) {
        ServletContext sc = request.getSession().getServletContext();
        ServiceFacade serviceFacade = new ServiceFacade();
        ServiceFactory serviceFactory = serviceFacade.getServiceFactory(new ServletContextWrapper(sc));
        RequestWrapper requestW = RequestWrapperFactory.create(request);
        return serviceFactory.getService(targetMetaDef, requestW);
    }

    public static Object getComponentInstance(String name, HttpServletRequest request) {
        ServletContext sc = request.getSession().getServletContext();
        ContainerWrapper containerWrapper = scf.findContainer(new ServletContextWrapper(sc));
        if (!containerWrapper.isStart()) {
            Debug.logError("JdonFramework not yet started, please try later ", module);
            return null;
        }
        return containerWrapper.lookup(name);
    }

    public static Object getComponentInstance(String name, ServletContext sc) {
        ContainerWrapper containerWrapper = scf.findContainer(new ServletContextWrapper(sc));
        if (!containerWrapper.isStart()) {
            Debug.logError("JdonFramework not yet started, please try later ", module);
            return null;
        }
        return containerWrapper.lookup(name);
    }

    public static Object callService(String serviceName, String methodName, Object[] methodParams, HttpServletRequest request) throws Exception {
        Debug.logVerbose("[JdonFramework] call the method: " + methodName + " for the service: " + serviceName, module);
        Object result = null;
        try {
            MethodMetaArgs methodMetaArgs = AppUtil.createDirectMethod(methodName, methodParams);
            ServiceFacade serviceFacade = new ServiceFacade();
            ServletContext sc = request.getSession().getServletContext();
            Service service = serviceFacade.getService(new ServletContextWrapper(sc));
            RequestWrapper requestW = RequestWrapperFactory.create(request);
            result = service.execute(serviceName, methodMetaArgs, requestW);
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] serviceAction Error: " + ex, module);
            throw new Exception(" serviceAction Error:" + ex);
        }
        return result;
    }

    public static String getContainerKey() {
        return "ContainerBuilder";
    }

    public static String getInterceptorKey() {
        return "InterceptorsChain";
    }

    public static ContainerWrapper getContainer(HttpServletRequest request) throws Exception {
        ContainerFinderImp scf = new ContainerFinderImp();
        ServletContext sc = request.getSession().getServletContext();
        return scf.findContainer(new ServletContextWrapper(sc));
    }

    public static ContainerWrapper getContainer(ServletContext sc) throws Exception {
        ContainerFinderImp scf = new ContainerFinderImp();
        return scf.findContainer(new ServletContextWrapper(sc));
    }
}

