/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.controller.cache;

import com.jdon.cache.CacheableWrapper;
import com.jdon.container.pico.Startable;
import com.jdon.controller.cache.Cache;
import com.jdon.controller.cache.StringKey;

public class CacheManager
implements Startable {
    private Cache cache;

    public CacheManager(Cache cache) {
        this.cache = cache;
    }

    public void start() {
        this.clear();
    }

    public void stop() {
        this.clear();
        this.cache = null;
    }

    public void clear() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public Object fetchObject(StringKey skey) {
        return this.fetchObject(skey.getKey());
    }

    public Object fetchObject(String skey) {
        CacheableWrapper cw = (CacheableWrapper)this.cache.get(skey);
        if (cw != null) {
            return cw.getCachedValue();
        }
        return null;
    }

    public boolean containObject(StringKey skey) {
        return this.cache.contain(skey.getKey());
    }

    public void putObect(StringKey ckey, Object value) {
        if (ckey == null) {
            return;
        }
        if (this.cache.contain(ckey.getKey())) {
            return;
        }
        this.cache.put(ckey.getKey(), new CacheableWrapper(ckey.getDataKey(), value));
    }

    public Object putIfAbsent(StringKey ckey, Object value) {
        CacheableWrapper co = (CacheableWrapper)this.cache.putIfAbsent(ckey.getKey(), new CacheableWrapper(ckey.getDataKey(), value));
        return co != null ? co.getCachedValue() : null;
    }

    public void removeObect(StringKey skey) {
        if (skey == null || this.cache == null) {
            return;
        }
        this.cache.remove(skey.getKey());
    }

    public void removeObect(String skey) {
        if (skey == null) {
            return;
        }
        this.cache.remove(skey);
    }

    public void removeCache(Object dataKey) {
        if (dataKey == null) {
            return;
        }
        try {
            for (Object o : this.cache.keySet()) {
                CacheableWrapper cw;
                String key = (String)o;
                Object cachedValue = this.cache.get(key);
                if (!(cachedValue instanceof CacheableWrapper) || !(cw = (CacheableWrapper)cachedValue).getCachedValueKey().equals(dataKey.toString())) continue;
                this.removeObect(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Cache getCache() {
        return this.cache;
    }
}

