/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.controller.service;

import com.jdon.container.ContainerWrapper;
import com.jdon.container.access.ServiceAccessor;
import com.jdon.container.access.TargetMetaRequest;
import com.jdon.container.access.TargetMetaRequestsHolder;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.container.visitor.ComponentVisitor;
import com.jdon.container.visitor.data.SessionContext;
import com.jdon.container.visitor.data.SessionContextSetup;
import com.jdon.controller.context.RequestWrapper;
import com.jdon.controller.service.WebServiceAccessor;
import com.jdon.util.Debug;

public class WebServiceAccessorImp
implements WebServiceAccessor {
    private static final String module = WebServiceAccessorImp.class.getName();
    private final ServiceAccessor serviceAccessor;
    private final ContainerCallback containerCallback;
    private final TargetMetaRequestsHolder targetMetaRequestsHolder;

    public WebServiceAccessorImp(ServiceAccessor serviceAccessor, TargetMetaRequestsHolder targetMetaRequestsHolder, ContainerCallback containerCallback) {
        this.serviceAccessor = serviceAccessor;
        this.containerCallback = containerCallback;
        this.targetMetaRequestsHolder = targetMetaRequestsHolder;
    }

    public Object getService(RequestWrapper request) {
        ContainerWrapper cw = this.containerCallback.getContainerWrapper();
        SessionContextSetup sessionContextSetup = (SessionContextSetup)cw.lookup("sessionContextSetup");
        TargetMetaRequest targetMetaRequest = this.targetMetaRequestsHolder.getTargetMetaRequest();
        targetMetaRequest.setVisitableName("sessionContextFactoryVisitable");
        ComponentVisitor componentVisitor = targetMetaRequest.getComponentVisitor();
        SessionContext sessionContext = componentVisitor.createSessionContext();
        targetMetaRequest.setSessionContext(sessionContext);
        sessionContextSetup.setup(sessionContext, request);
        return this.serviceAccessor.getService();
    }

    public Object getService() {
        return this.serviceAccessor.getService();
    }

    public Object execute(RequestWrapper request) throws Exception {
        ContainerWrapper cw = this.containerCallback.getContainerWrapper();
        if (!cw.isStart()) {
            Debug.logError("JdonFramework not yet started, please try later ", module);
            return null;
        }
        SessionContextSetup sessionContextSetup = (SessionContextSetup)cw.lookup("sessionContextSetup");
        TargetMetaRequest targetMetaRequest = this.targetMetaRequestsHolder.getTargetMetaRequest();
        ComponentVisitor componentVisitor = targetMetaRequest.getComponentVisitor();
        targetMetaRequest.setVisitableName("sessionContextFactoryVisitable");
        SessionContext sessionContext = componentVisitor.createSessionContext();
        targetMetaRequest.setSessionContext(sessionContext);
        sessionContextSetup.setup(sessionContext, request);
        return this.serviceAccessor.executeService(cw);
    }

    public Object execute() throws Exception {
        ContainerWrapper cw = this.containerCallback.getContainerWrapper();
        if (!cw.isStart()) {
            Debug.logError("JdonFramework not yet started, please try later ", module);
            return null;
        }
        return this.serviceAccessor.executeService(cw);
    }
}

