/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.domain.advsior;

import com.jdon.aop.joinpoint.AdvisorChainFactory;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.container.interceptor.CGLIBMethodInterceptorImp;
import com.jdon.container.interceptor.IntroduceInfo;
import com.jdon.container.interceptor.IntroduceInfoHolder;
import com.jdon.container.interceptor.ProxyFactory;
import com.jdon.util.ClassUtil;
import com.jdon.util.Debug;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;

public class ComponentAdvsior {
    private static final String module = ComponentAdvsior.class.getName();
    public static final String NAME = "componentAdvsior";
    private final ContainerCallback containerCallback;
    private final Map<String, Class[]> interfaceMaps = new HashMap<String, Class[]>();

    public ComponentAdvsior(ContainerCallback containerCallback) {
        this.containerCallback = containerCallback;
    }

    public Object createProxy(Object o) {
        if (o == null) {
            return o;
        }
        IntroduceInfoHolder introduceInfoHolder = (IntroduceInfoHolder)this.containerCallback.getContainerWrapper().lookup(IntroduceInfoHolder.NAME);
        if (introduceInfoHolder == null) {
            return o;
        }
        if (!introduceInfoHolder.containsThisClass(o.getClass())) {
            return o;
        }
        try {
            Class[] interfaces = this.getInterfaces(o.getClass());
            if (interfaces == null) {
                Debug.logError(" Your class:" + o.getClass() + " has a annotation @Introduce, the class need implement a interface when it be register in container", module);
                return o;
            }
            IntroduceInfo iinfo = introduceInfoHolder.getIntroduceInfoByIntroducer(o.getClass());
            Object interceptor = null;
            if (iinfo != null) {
                interceptor = this.containerCallback.getContainerWrapper().getComponentNewInstance(iinfo.getAdviceName());
            }
            AdvisorChainFactory acf = (AdvisorChainFactory)this.containerCallback.getContainerWrapper().lookup("advisorChainFactory");
            String targetName = introduceInfoHolder.getTargetName(o.getClass());
            if (targetName == null) {
                return o;
            }
            List<MethodInterceptor> methodInterceptors = acf.createTargetAdvice(targetName);
            CGLIBMethodInterceptorImp mi = new CGLIBMethodInterceptorImp(o, interceptor, iinfo, methodInterceptors);
            ProxyFactory proxyFactory = (ProxyFactory)this.containerCallback.getContainerWrapper().lookup("domainProxyFactory");
            o = proxyFactory.createProxy(mi, o, interfaces);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return o;
    }

    public Class[] getInterfaces(Class pojoClass) {
        Class[] interfaces = this.interfaceMaps.get(pojoClass.getName());
        if (interfaces == null) {
            interfaces = ClassUtil.getParentAllInterfaces(pojoClass);
            this.interfaceMaps.put(pojoClass.getName(), interfaces);
        }
        return interfaces;
    }
}

