/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.domain.message;

import com.jdon.async.EventResultHandler;
import com.jdon.async.disruptor.EventResultHandlerImp;
import com.jdon.domain.message.Command;
import java.util.concurrent.atomic.AtomicReference;

public class DomainMessage
extends Command {
    protected Object eventSource;
    protected volatile EventResultHandler eventResultHandler;
    protected volatile AtomicReference<Object> eventResultCache = new AtomicReference();

    public DomainMessage(Object eventSource) {
        this.eventSource = eventSource;
        this.eventResultHandler = new EventResultHandlerImp(10000);
    }

    public DomainMessage(Object eventSource, int timeoutforeturnResult) {
        this.eventSource = eventSource;
        this.eventResultHandler = new EventResultHandlerImp(timeoutforeturnResult);
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public EventResultHandler getEventResultHandler() {
        return this.eventResultHandler;
    }

    public void setEventResultHandler(EventResultHandler eventResultHandler) {
        this.eventResultHandler = eventResultHandler;
    }

    public void setTimeoutforeturnResult(int timeoutforeturnResult) {
        if (this.eventResultHandler != null) {
            this.eventResultHandler.setWaitforTimeout(timeoutforeturnResult);
        }
    }

    public Object getEventResult() {
        Object result = this.eventResultCache.get();
        if (result != null) {
            return result;
        }
        if (this.eventResultHandler != null && (result = this.eventResultHandler.get()) != null && !this.eventResultCache.compareAndSet(null, result)) {
            result = this.eventResultCache.get();
        }
        return result;
    }

    public Object getBlockEventResult() {
        Object result = this.eventResultCache.get();
        if (result != null) {
            return result;
        }
        if (this.eventResultHandler != null && (result = this.eventResultHandler.getBlockedValue()) != null && !this.eventResultCache.compareAndSet(null, result)) {
            result = this.eventResultCache.get();
        }
        return result;
    }

    public void setEventResult(Object eventResultValue) {
        if (this.eventResultHandler != null) {
            this.eventResultHandler.send(eventResultValue);
        }
    }

    public void setEventSource(Object eventSource) {
        this.eventSource = eventSource;
    }

    public void clear() {
        this.eventResultHandler = null;
        this.eventSource = null;
    }

    public boolean isNull() {
        return this.eventResultHandler == null;
    }
}

