/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.domain.model.cache;

import com.jdon.container.pico.Startable;
import com.jdon.controller.cache.CacheKey;
import com.jdon.controller.cache.CacheKeyFactory;
import com.jdon.controller.cache.CacheManager;
import com.jdon.controller.model.ModelUtil;
import com.jdon.domain.model.cache.ModelCacheKeyFactory;

public class ModelCacheManager
implements Startable {
    protected CacheManager cacheManager;
    private final CacheKeyFactory cacheKeyFactory;

    public ModelCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.cacheKeyFactory = new ModelCacheKeyFactory();
    }

    public void start() {
    }

    public void stop() {
        this.cacheManager.clear();
        this.cacheManager = null;
    }

    public Object getPModel(Class modelClass) {
        System.out.print("o=" + modelClass.getName());
        Class pClass = modelClass.getSuperclass();
        if (pClass == null) {
            return modelClass;
        }
        if (pClass.getName().equalsIgnoreCase(Object.class.getName())) {
            return modelClass;
        }
        return this.getPModel(pClass);
    }

    public void saveCache(Object dataKey, String modelClassName, Object model) {
        CacheKey cachKey = this.cacheKeyFactory.createCacheKey(dataKey.toString(), modelClassName);
        this.saveToCache(cachKey, model);
    }

    public Object saveCacheIfAbsent(Object dataKey, String modelClassName, Object model) {
        if (dataKey == null) {
            return null;
        }
        CacheKey cachKey = this.cacheKeyFactory.createCacheKey(dataKey.toString(), modelClassName);
        if (cachKey == null) {
            return null;
        }
        return this.cacheManager.putIfAbsent(cachKey, model);
    }

    protected void saveToCache(CacheKey cachKey, Object model) {
        if (!this.cacheManager.containObject(cachKey)) {
            this.cacheManager.putObect(cachKey, model);
        }
    }

    private Object getModelFromCache(CacheKey cachKey) {
        Object model = this.cacheManager.fetchObject(cachKey);
        if (model != null && ModelUtil.isModified(model)) {
            this.removeCache(cachKey);
            model = null;
        }
        return model;
    }

    public Object getCache(Object dataKey, String modelClassName) {
        CacheKey cachKey = this.cacheKeyFactory.createCacheKey(dataKey.toString(), modelClassName);
        return this.getModelFromCache(cachKey);
    }

    public boolean containInCache(Object dataKey, String modelClassName) {
        CacheKey cachKey = this.cacheKeyFactory.createCacheKey(dataKey.toString(), modelClassName);
        return this.cacheManager.containObject(cachKey);
    }

    public void removeCache(Object dataKey) {
        this.cacheManager.removeCache(dataKey);
    }

    public void removeCache2(Object dataKey, String modelClassName) {
        CacheKey cachKey = this.cacheKeyFactory.createCacheKey(dataKey.toString(), modelClassName);
        this.cacheManager.removeObect(cachKey);
    }

    public void clearCache() {
        this.cacheManager.clear();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

