/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.domain.model.injection;

import com.jdon.annotation.Component;
import com.jdon.annotation.Service;
import com.jdon.annotation.model.Inject;
import com.jdon.container.finder.ContainerCallback;
import com.jdon.domain.advsior.ModelAdvisor;
import com.jdon.util.ClassUtil;
import com.jdon.util.Debug;
import com.jdon.util.ObjectCreator;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;

public class ModelProxyInjection {
    private static final String module = ModelProxyInjection.class.getName();
    private ModelAdvisor modelAdvisor;
    private ContainerCallback containerCallback;

    public ModelProxyInjection(ModelAdvisor modelAdvisor, ContainerCallback containerCallback) {
        this.modelAdvisor = modelAdvisor;
        this.containerCallback = containerCallback;
    }

    public void injectProperties(Object targetModel) {
        Class<?> fClass = null;
        try {
            Field[] fields = ClassUtil.getAllDecaredFields(targetModel.getClass());
            if (fields == null) {
                return;
            }
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Inject.class)) continue;
                fClass = field.getType();
                Object fieldObject = this.getInjectObject(targetModel, fClass);
                if (!field.getType().isAssignableFrom(fieldObject.getClass())) continue;
                try {
                    field.setAccessible(true);
                    field.set(targetModel, fieldObject);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            Debug.logError("inject Properties error:" + e + " in " + targetModel.getClass() + "'s field: " + fClass, module);
        }
    }

    protected Object getInjectObject(Object targetModel, Class fClass) {
        Object o = this.createTargetComponent(targetModel, fClass);
        if (o == null) {
            o = this.createTargetObject(targetModel, fClass);
        }
        return o;
    }

    protected Object createTargetObject(Object targetModel, Class fClass) {
        Object o = null;
        try {
            o = ObjectCreator.createObject(fClass);
            o = this.modelAdvisor.createProxy(o);
        }
        catch (Exception e) {
            Debug.logError("createTargetObject error:" + e + " in " + targetModel.getClass(), module);
        }
        return o;
    }

    protected Object createTargetComponent(Object targetModel, Class fClass) {
        Object o = null;
        try {
            List objects = this.containerCallback.getContainerWrapper().getComponentInstancesOfType(fClass);
            Iterator iterator = objects.iterator();
            if (iterator.hasNext()) {
                Object instance = iterator.next();
                o = instance;
            }
            if (o != null) {
                o = this.modelAdvisor.createProxy(o);
            }
        }
        catch (Exception e) {
            Debug.logError("createTargetComponent error:" + e + " in" + targetModel.getClass(), module);
        }
        return o;
    }

    protected boolean isComponent(Object instance) {
        if (instance.getClass().isAnnotationPresent(Component.class)) {
            return true;
        }
        return instance.getClass().isAnnotationPresent(Service.class);
    }
}

