/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class ClassUtil {
    public static Class[] getParentAllInterfaces(Class pojoClass) {
        Class[] interfaces = null;
        try {
            ArrayList interfacesL = new ArrayList();
            while (pojoClass != null) {
                for (int i = 0; i < pojoClass.getInterfaces().length; ++i) {
                    Class<?> ifc = pojoClass.getInterfaces()[i];
                    if (ifc.getName().startsWith("java.")) continue;
                    interfacesL.add(ifc);
                }
                pojoClass = pojoClass.getSuperclass();
            }
            if (interfacesL.size() == 0) {
                throw new Exception();
            }
            interfaces = interfacesL.toArray(new Class[interfacesL.size()]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return interfaces;
    }

    public static Class[] getAllInterfaces(Class clazz) {
        if (clazz == null) {
            return new Class[0];
        }
        HashSet<Class> classList = new HashSet<Class>();
        while (clazz != null) {
            Class<?>[] interfaces;
            for (Class<?> interf : interfaces = clazz.getInterfaces()) {
                Class[] superInterfaces;
                if (!classList.contains(interf)) {
                    classList.add(interf);
                }
                for (Class superIntf : superInterfaces = ClassUtil.getAllInterfaces(interf)) {
                    if (classList.contains(superIntf)) continue;
                    classList.add(superIntf);
                }
            }
            clazz = clazz.getSuperclass();
        }
        return classList.toArray(new Class[classList.size()]);
    }

    public static Field[] getAllDecaredFields(Class clazz) {
        Class[] superClasses;
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class superClass : superClasses = ClassUtil.getAllSuperclasses(clazz)) {
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static Class finddAnnotationForMethod(Class clazz, Class annotationClass) {
        Class[] superClasses = ClassUtil.getAllSuperclasses(clazz);
        if (superClasses != null) {
            for (Class superClass : superClasses) {
                if (!superClass.isAnnotationPresent(annotationClass)) continue;
                return superClass;
            }
        }
        if ((superClasses = ClassUtil.getParentAllInterfaces(clazz)) != null) {
            for (Class superClass : superClasses) {
                if (!superClass.isAnnotationPresent(annotationClass)) continue;
                return superClass;
            }
        }
        return null;
    }

    public static Method finddAnnotationForMethod(Method m, Class annotationClass) {
        try {
            Class[] superClasses = ClassUtil.getAllSuperclasses(m.getDeclaringClass());
            if (superClasses != null) {
                for (Class superClass : superClasses) {
                    for (Method ms : superClass.getDeclaredMethods()) {
                        if (!ms.isAnnotationPresent(annotationClass) || ms.getName() != m.getName()) continue;
                        return ms;
                    }
                }
            }
            if ((superClasses = ClassUtil.getParentAllInterfaces(m.getDeclaringClass())) != null) {
                for (Class superClass : superClasses) {
                    for (Method ms : superClass.getDeclaredMethods()) {
                        if (!ms.isAnnotationPresent(annotationClass) || ms.getName() != m.getName()) continue;
                        return ms;
                    }
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Method[] getAllDecaredMethods(Class clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        try {
            Class[] superClasses;
            for (Class superClass : superClasses = ClassUtil.getAllSuperclasses(clazz)) {
                methods.addAll(Arrays.asList(superClass.getDeclaredMethods()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return methods.toArray(new Method[methods.size()]);
    }

    public static Class[] getAllSuperclasses(Class cls) {
        if (cls == null) {
            return new Class[0];
        }
        ArrayList classList = new ArrayList();
        for (Class superClass = cls; superClass != null && !Object.class.equals((Object)superClass) && !Class.class.equals((Object)superClass); superClass = superClass.getSuperclass()) {
            classList.add(superClass);
        }
        return classList.toArray(new Class[classList.size()]);
    }

    public static Field getDecaredField(Class clazz, String name) throws NoSuchFieldException {
        Class[] superClasses;
        Field field = null;
        for (Class superClass : superClasses = ClassUtil.getAllSuperclasses(clazz)) {
            try {
                field = superClass.getDeclaredField(name);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        if (field == null) {
            throw new NoSuchFieldException("No such declared field " + name + " in " + clazz);
        }
        return field;
    }
}

