/*
 * Decompiled with CFR 0.152.
 */
package com.jdon.util;

import com.jdon.util.Debug;
import com.jdon.util.FileLocator;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class XmlUtil {
    public static final String module = XmlUtil.class.getName();

    public static Map loadMapping(String fileName, String nodeName, String keyName, String valueName) {
        HashMap<String, String> map = new HashMap<String, String>();
        FileLocator fileLocator = new FileLocator();
        try {
            String xmlFile = fileLocator.getConfFile(fileName);
            Debug.logVerbose("[JdonFramework] mapping file:" + xmlFile, module);
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(new File(xmlFile));
            Debug.logVerbose("[JdonFramework] got mapping file ", module);
            Element root = doc.getRootElement();
            List mappings = root.getChildren(nodeName);
            for (Element mapping : mappings) {
                String key = mapping.getChild(keyName).getTextTrim();
                String value = mapping.getChild(valueName).getTextTrim();
                Debug.logVerbose("[JdonFramework] get the " + key + "=" + value, module);
                map.put(key, value);
            }
            Debug.logVerbose("[JdonFramework] read finished", module);
        }
        catch (Exception ex) {
            Debug.logError("[JdonFramework] error: " + ex, module);
        }
        return map;
    }
}

