/*
 * JDrupes Builder
 * Copyright (C) 2025 Michael N. Lipp
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.jdrupes.builder.mvnrepo;

import org.jdrupes.builder.api.PropertyKey;

/// Additional properties used with maven repositories.
///
public enum MvnProperties implements PropertyKey {

    /// The group that the project's artifacts belong to. Defaults to `null`.
    @SuppressWarnings("PMD.FieldNamingConventions")
    GroupId(null),
    
    /// The artifact id. Defaults to `null`.
    @SuppressWarnings("PMD.FieldNamingConventions")
    ArtifactId(null);
    
    private final Object defaultValue;

    <T> MvnProperties(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T> T defaultValue() {
        return (T)defaultValue;
    }
}