/*
 * JDrupes Builder
 * Copyright (C) 2025 Michael N. Lipp
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.jdrupes.builder.startup;

import static org.jdrupes.builder.api.Intend.*;
import org.jdrupes.builder.api.Masked;
import org.jdrupes.builder.api.RootProject;
import org.jdrupes.builder.core.AbstractProject;

/// The built-in root project associated with the root directory.
///
public class BootstrapRoot extends AbstractProject
        implements RootProject, Masked {

    /// Instantiates a new bootstrap root.
    ///
    @SuppressWarnings("PMD.ConstructorCallsOverridableMethod")
    public BootstrapRoot() {
        dependency(Expose, project(BootstrapBuild.class));
    }
}
