/*
 * JDrupes Builder
 * Copyright (C) 2025 Michael N. Lipp
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.jdrupes.builder.java;

import org.jdrupes.builder.api.FileTree;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.api.Resources;

/// A collection of Java specific [ResourceType]s.
///
@SuppressWarnings({ "PMD.FieldNamingConventions", "PMD.DataClass" })
public final class JavaTypes {

    private JavaTypes() {
    }

    /// The Java source file.
    public static final ResourceType<JavaSourceFile> JavaSourceFileType
        = new ResourceType<>() {};

    /// The Java source files.
    public static final ResourceType<
            FileTree<JavaSourceFile>> JavaSourceTreeType
                = new ResourceType<>() {};

    /// The class file.
    public static final ResourceType<ClassFile> ClassFileType
        = new ResourceType<>() {};

    /// The Java class files.
    public static final ResourceType<ClassTree> ClassTreeType
        = new ResourceType<>() {};

    /// Resource files.
    @SuppressWarnings("PMD.FieldNamingConventions")
    public static final ResourceType<JavaResourceTree> JavaResourceTreeType
        = new ResourceType<>() {};

    /// The Java jar file.
    public static final ResourceType<JarFile> JarFileType
        = new ResourceType<>() {};

    /// A resource that can be put on the classpath.
    public static final ResourceType<ClasspathElement> ClasspathElementType
        = new ResourceType<>() {};

    /// The most general representation of a classpath.
    public static final ResourceType<Resources<ClasspathElement>> ClasspathType
        = new ResourceType<>() {};

    /// Contributions to the compilation classpath.
    public static final ResourceType<
            CompilationResources> CompilationResourcesType
                = new ResourceType<>() {};

    /// Contributions to the runtime classpath.
    public static final ResourceType<RuntimeResources> RuntimeResourcesType
        = new ResourceType<>() {};

    /// The directory with files generated by javadoc.
    public static final ResourceType<JavadocDirectory> JavadocDirectoryType
        = new ResourceType<>() {};

    /// The Java library jar file.
    public static final ResourceType<LibraryJarFile> LibraryJarFileType
        = new ResourceType<>() {};

    /// The Java application jar file.
    public static final ResourceType<AppJarFile> AppJarFileType
        = new ResourceType<>() {};

    /// The Java application jar file.
    public static final ResourceType<SourcesJarFile> SourcesJarFileType
        = new ResourceType<>() {};

    /// The javadoc jar file.
    public static final ResourceType<JavadocJarFile> JavadocJarFileType
        = new ResourceType<>() {};
}
