/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.api;

import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jdrupes.builder.api.BuildContext;
import org.jdrupes.builder.api.FromHelper;
import org.jdrupes.builder.api.Generator;
import org.jdrupes.builder.api.Intend;
import org.jdrupes.builder.api.PropertyKey;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceFactory;
import org.jdrupes.builder.api.ResourceProvider;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.api.RootProject;

public interface Project
extends ResourceProvider {
    public RootProject rootProject();

    public ResourceProvider project(Class<? extends Project> var1);

    public String name();

    public Path directory();

    public BuildContext context();

    default public Path buildDirectory() {
        return this.directory().resolve((Path)this.get(Properties.BuildDirectory));
    }

    public Project generator(Generator var1);

    default public <T extends Generator> T generator(Function<Project, T> supplier) {
        Generator provider = (Generator)supplier.apply(this);
        this.generator(provider);
        return (T)provider;
    }

    public Project dependency(Intend var1, ResourceProvider var2);

    default public <T extends ResourceProvider> T dependency(Intend intend, Function<Project, T> supplier) {
        ResourceProvider provider = (ResourceProvider)supplier.apply(this);
        this.dependency(intend, provider);
        return (T)provider;
    }

    public Stream<ResourceProvider> providers(Set<Intend> var1);

    default public Stream<ResourceProvider> providers(Intend intend, Intend ... intends) {
        return this.providers(EnumSet.of(intend, intends));
    }

    public <T extends Resource> Stream<T> getFrom(Stream<ResourceProvider> var1, ResourceRequest<T> var2);

    default public <T extends Resource> Stream<T> provided(ResourceRequest<T> requested) {
        return this.getFrom(this.providers(Intend.Consume, Intend.Expose), requested);
    }

    default public <T extends Resource> Stream<T> supplied(ResourceRequest<T> requested) {
        return this.getFrom(this.providers(Intend.Supply, new Intend[0]), requested);
    }

    default public Path relativize(Path other) {
        return this.directory().relativize(other);
    }

    public Project set(PropertyKey var1, Object var2);

    public <T> T get(PropertyKey var1);

    default public <T extends Resource> Stream<T> get(ResourceRequest<T> request) {
        return this.context().get(this, request);
    }

    default public FromHelper from(ResourceProvider provider) {
        return new FromHelper(this.context(), provider);
    }

    default public <T extends Resource> T newResource(ResourceType<T> type, Object ... args) {
        return ResourceFactory.create(type, this, args);
    }

    public static enum Properties implements PropertyKey
    {
        BuildDirectory(Path.of("build", new String[0])),
        Encoding("UTF-8"),
        Version("0.0.0");

        private final Object defaultValue;

        private <T> Properties(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public <T> T defaultValue() {
            return (T)this.defaultValue;
        }
    }
}

