/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.api;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.jdrupes.builder.api.ResourceType;

public interface Resource {
    default public Instant asOf() {
        return Instant.MIN;
    }

    public ResourceType<?> type();

    default public String asOfLocalized() {
        Instant asOf = this.asOf();
        if (asOf == Instant.MIN) {
            return "ages ago";
        }
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(asOf.atZone(ZoneId.systemDefault()));
    }
}

