/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.api;

import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceType;

public interface ResourceFactory {
    public static <T extends Resource> T create(ResourceType<T> type, Project project, Object ... args) {
        return (T)StreamSupport.stream(ServiceLoader.load(ResourceFactory.class).spliterator(), true).map(f -> f.newResource(type, project, args)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new BuildException("No resource factory for " + String.valueOf(type)));
    }

    public static <T extends Resource> T create(ResourceType<T> type, Object ... args) {
        return ResourceFactory.create(type, null, args);
    }

    public <T extends Resource> Optional<T> newResource(ResourceType<T> var1, Project var2, Object ... var3);
}

