/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.api;

import java.util.Objects;
import java.util.Optional;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.api.Resources;

public class ResourceRequest<T extends Resource> {
    private final ResourceType<? extends Resources<T>> type;

    public ResourceRequest(ResourceType<? extends Resources<T>> type) {
        this.type = type;
    }

    public static <C extends Resources<T>, T extends Resource> ResourceRequest<T> requestFor(Class<C> container, Class<T> requested) {
        return new ResourceRequest<T>(new ResourceType(container, new ResourceType(requested, null)));
    }

    public static <T extends Resource> ResourceRequest<T> requestFor(Class<T> requested) {
        return new ResourceRequest<T>(new ResourceType(Resources.class, new ResourceType(requested, null)));
    }

    public <R extends Resources<T>> ResourceRequest<T> widened(Class<? extends Resources> type) {
        return new ResourceRequest<T>(this.type().widened(type));
    }

    public ResourceType<? extends Resources<T>> type() {
        return this.type;
    }

    public boolean wants(ResourceType<?> other) {
        return this.type().isAssignableFrom(other);
    }

    public boolean includes(ResourceType<?> type) {
        return Optional.ofNullable(this.type().containedType()).map(ct -> ct.isAssignableFrom(type)).orElse(false);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceRequest other = (ResourceRequest)obj;
        return Objects.equals(this.type, other.type);
    }

    public String toString() {
        return "ResourceRequest [type=" + String.valueOf(this.type) + "]";
    }
}

