/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.api;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jdrupes.builder.api.Cleanliness;
import org.jdrupes.builder.api.FileResource;
import org.jdrupes.builder.api.IOResource;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceFile;
import org.jdrupes.builder.api.Resources;

public class ResourceType<T extends Resource> {
    public static final ResourceType<Cleanliness> CleanlinessType = new ResourceType<Cleanliness>(){};
    public static final ResourceType<ResourceFile> ResourceFileType = new ResourceType<ResourceFile>(){};
    public static final ResourceType<FileResource> FileResourceType = new ResourceType<FileResource>(){};
    public static final ResourceType<IOResource> IOResourceType = new ResourceType<IOResource>(){};
    public static final ResourceType<Resources<IOResource>> IOResourcesType = new ResourceType<Resources<IOResource>>(Resources.class, IOResourceType){};
    private final Class<T> type;
    private final ResourceType<?> containedType;

    public ResourceType(Class<? extends Resource> type, ResourceType<?> containedType) {
        this.type = type;
        this.containedType = containedType;
    }

    public static <C extends Resources<T>, T extends Resource> ResourceType<C> resourceType(Class<C> type, Class<T> containedType) {
        return new ResourceType<T>(type, ResourceType.resourceType(containedType));
    }

    public static <T extends Resource> ResourceType<T> resourceType(Class<T> type) {
        return new ResourceType<T>(type, null);
    }

    private ResourceType(Type type) {
        ParameterizedType pType;
        WildcardType wType;
        if (type instanceof WildcardType && Object.class.equals(type = (wType = (WildcardType)type).getUpperBounds()[0])) {
            type = Resource.class;
        }
        if (type instanceof ParameterizedType && Resources.class.isAssignableFrom((Class)(pType = (ParameterizedType)type).getRawType())) {
            this.type = (Class)pType.getRawType();
            Type argType = pType.getActualTypeArguments()[0];
            if (argType instanceof ParameterizedType) {
                ParameterizedType pArgType = (ParameterizedType)argType;
                this.containedType = new ResourceType<T>(pArgType);
            } else {
                Type subType = pType.getActualTypeArguments()[0];
                this.containedType = new ResourceType<T>(subType);
            }
            return;
        }
        this.type = (Class)type;
        this.containedType = Stream.concat(Optional.ofNullable(((Class)type).getGenericSuperclass()).stream(), ResourceType.getAllInterfaces((Class)type).map(Class::getGenericInterfaces).map(Arrays::stream).flatMap(s -> s)).filter(t -> {
            ParameterizedType pType;
            return t instanceof ParameterizedType && Resources.class.isAssignableFrom((Class)(pType = (ParameterizedType)t).getRawType());
        }).map(t -> (ParameterizedType)t).findFirst().map(t -> new ResourceType(Resources.class, new ResourceType((Type)t).containedType())).orElseGet(() -> new ResourceType(Resources.class, null)).containedType();
    }

    public static Stream<Class<?>> getAllInterfaces(Class<?> clazz) {
        return Stream.concat(Stream.of(clazz), Arrays.stream(clazz.getInterfaces()).map(ResourceType::getAllInterfaces).flatMap(s -> s));
    }

    protected ResourceType() {
        Type resourceType = this.getClass().getGenericSuperclass();
        try {
            Type theResource = ((ParameterizedType)resourceType).getActualTypeArguments()[0];
            ResourceType<T> tempType = new ResourceType<T>(theResource);
            this.type = tempType.rawType();
            this.containedType = tempType.containedType();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Could not derive resource type for " + String.valueOf(resourceType), e);
        }
    }

    public Class<T> rawType() {
        return this.type;
    }

    public ResourceType<?> containedType() {
        return this.containedType;
    }

    public boolean isAssignableFrom(ResourceType<?> other) {
        if (!this.type.isAssignableFrom(other.type)) {
            return false;
        }
        if (Objects.isNull(this.containedType)) {
            return true;
        }
        if (Objects.isNull(other.containedType)) {
            return false;
        }
        return this.containedType.isAssignableFrom(other.containedType);
    }

    public <R extends Resource> ResourceType<R> widened(Class<? extends Resource> type) {
        if (!type.isAssignableFrom(this.type)) {
            throw new IllegalArgumentException("Cannot replace " + String.valueOf(this.type) + " with " + String.valueOf(type) + " because it is not a super class");
        }
        if (Resources.class.isAssignableFrom(this.type) && !Resources.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Cannot replace container type " + String.valueOf(this.type) + " with non-container type " + String.valueOf(type));
        }
        ResourceType<T> result = new ResourceType<T>(type, this.containedType);
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.containedType, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!ResourceType.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ResourceType other = (ResourceType)obj;
        return Objects.equals(this.containedType, other.containedType) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return this.type.getSimpleName() + (String)(this.containedType == null ? "" : "(" + String.valueOf(this.containedType) + ")");
    }
}

