/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jdrupes.builder.api.Generator;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.core.AbstractProvider;

public abstract class AbstractGenerator
extends AbstractProvider
implements Generator {
    private final Project project;
    private String name;

    public AbstractGenerator(Project project) {
        this.project = project;
        this.name = this.getClass().getSimpleName();
        if (this.name.isBlank()) {
            this.name = "Adapted " + this.getClass().getSuperclass().getSimpleName();
        }
    }

    public AbstractGenerator name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public final Project project() {
        return this.project;
    }

    protected boolean cleanup(ResourceRequest<?> requested, Path ... files) {
        if (!requested.includes(ResourceType.CleanlinessType)) {
            return false;
        }
        Path[] pathArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Path file = pathArray[n2];
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException e) {
                this.log.warning(() -> String.valueOf(file) + " cannot be deleted.");
            }
            ++n2;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.name + " in project " + this.project().name();
    }
}

