/*
 * Decompiled with CFR 0.152.
 */
package org.jdrupes.builder.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.jdrupes.builder.api.BuildException;
import org.jdrupes.builder.api.Cleanliness;
import org.jdrupes.builder.api.Generator;
import org.jdrupes.builder.api.Intend;
import org.jdrupes.builder.api.NamedParameter;
import org.jdrupes.builder.api.Project;
import org.jdrupes.builder.api.PropertyKey;
import org.jdrupes.builder.api.Resource;
import org.jdrupes.builder.api.ResourceProvider;
import org.jdrupes.builder.api.ResourceRequest;
import org.jdrupes.builder.api.ResourceType;
import org.jdrupes.builder.api.Resources;
import org.jdrupes.builder.api.RootProject;
import org.jdrupes.builder.core.AbstractProvider;
import org.jdrupes.builder.core.DefaultBuildContext;

public abstract class AbstractProject
extends AbstractProvider
implements Project {
    private Map<Class<? extends Project>, Future<Project>> projects;
    private static ThreadLocal<AbstractProject> fallbackParent = new ThreadLocal();
    private static Path jdbldDirectory = Path.of("marker:jdbldDirectory", new String[0]);
    private final AbstractProject parent;
    private final String projectName;
    private final Path projectDirectory;
    private final Map<ResourceProvider, Intend> providers = new ConcurrentHashMap<ResourceProvider, Intend>();
    private final Map<PropertyKey, Object> properties = new HashMap<PropertyKey, Object>();
    private DefaultBuildContext context;
    private Map<String, ResourceRequest<?>[]> commands;

    protected static NamedParameter<Class<? extends Project>> parent(Class<? extends Project> parentProject) {
        return new NamedParameter<Class<? extends Project>>("parent", parentProject);
    }

    protected static NamedParameter<String> name(String name) {
        return new NamedParameter<String>("name", name);
    }

    protected static NamedParameter<Path> directory(Path directory) {
        return new NamedParameter<Path>("directory", directory);
    }

    protected static NamedParameter<Path> jdbldDirectory() {
        return new NamedParameter<Path>("directory", jdbldDirectory);
    }

    protected AbstractProject(NamedParameter<?> ... params) {
        String name;
        Class parentProject = (Class)NamedParameter.get(params, "parent", null);
        if (parentProject == null) {
            this.parent = fallbackParent.get();
            if (this instanceof RootProject) {
                if (this.parent != null) {
                    throw new BuildException("Root project of type " + this.getClass().getSimpleName() + " cannot be a sub project.");
                }
                this.projects = Collections.synchronizedMap(new HashMap());
                this.context = new DefaultBuildContext();
                this.commands = new HashMap<String, ResourceRequest[]>(Map.of("clean", new ResourceRequest[]{new ResourceRequest<Cleanliness>(new ResourceType<Resources<Cleanliness>>(){})}));
            }
        } else {
            this.parent = (AbstractProject)this.project(parentProject);
        }
        this.projectName = name = NamedParameter.get(params, "name", () -> this.getClass().getSimpleName());
        Path directory = (Path)NamedParameter.get(params, "directory", null);
        if (directory == jdbldDirectory) {
            directory = this.context().jdbldDirectory();
        }
        if (this.parent == null) {
            if (directory != null) {
                throw new BuildException("Root project of type " + this.getClass().getSimpleName() + " cannot specify a directory.");
            }
            this.projectDirectory = Path.of("", new String[0]).toAbsolutePath();
        } else {
            if (directory == null) {
                directory = Path.of(this.projectName.toLowerCase(), new String[0]);
            }
            this.projectDirectory = this.parent.directory().resolve(directory);
            this.parent.dependency(Intend.Forward, this);
        }
        try {
            this.rootProject().prepareProject(this);
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    @Override
    public final RootProject rootProject() {
        AbstractProject abstractProject = this;
        if (abstractProject instanceof RootProject) {
            RootProject root = (RootProject)((Object)abstractProject);
            return root;
        }
        return Optional.ofNullable(this.parent).orElse(fallbackParent.get()).rootProject();
    }

    @Override
    public ResourceProvider project(Class<? extends Project> prjCls) {
        if (this.getClass().equals(prjCls)) {
            return this;
        }
        if (this.projects == null) {
            return this.rootProject().project(prjCls);
        }
        try {
            return (ResourceProvider)this.projects.computeIfAbsent(prjCls, k -> this.context().executor().submit(() -> {
                try {
                    fallbackParent.set(this);
                    Project project = (Project)k.getConstructor(new Class[0]).newInstance(new Object[0]);
                    return project;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    fallbackParent.set(null);
                }
            })).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BuildException(e);
        }
    }

    @Override
    public String name() {
        return this.projectName;
    }

    @Override
    public Path directory() {
        return this.projectDirectory;
    }

    @Override
    public Project generator(Generator provider) {
        this.providers.put(provider, Intend.Supply);
        return this;
    }

    @Override
    public Project dependency(Intend intend, ResourceProvider provider) {
        this.providers.put(provider, intend);
        return this;
    }

    @Override
    public Stream<ResourceProvider> providers(Set<Intend> intends) {
        return this.providers.entrySet().stream().filter(e -> intends.contains(e.getValue())).map(Map.Entry::getKey);
    }

    @Override
    public <T extends Resource> Stream<T> getFrom(Stream<ResourceProvider> providers, ResourceRequest<T> request) {
        return providers.map(p -> this.context().get((ResourceProvider)p, request)).toList().stream().flatMap(s -> s);
    }

    @Override
    public DefaultBuildContext context() {
        return ((AbstractProject)((Object)this.rootProject())).context;
    }

    @Override
    public <T> T get(PropertyKey property) {
        return (T)Optional.ofNullable(this.properties.get(property)).orElseGet(() -> {
            if (this.parent != null) {
                return this.parent.get(property);
            }
            return property.defaultValue();
        });
    }

    @Override
    public AbstractProject set(PropertyKey property, Object value) {
        if (!property.type().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Value for " + String.valueOf(property) + " must be of type " + String.valueOf(property.type()));
        }
        this.properties.put(property, value);
        return this;
    }

    protected <R extends Resource> Stream<R> doProvide(ResourceRequest<R> requested) {
        return this.getFrom(this.providers(EnumSet.of(Intend.Forward, Intend.Expose, Intend.Supply)), requested);
    }

    public RootProject commandAlias(String name, ResourceRequest<?> ... requests) {
        if (this.commands == null) {
            throw new BuildException("Commands can only be defined for the root project.");
        }
        this.commands.put(name, requests);
        return (RootProject)((Object)this);
    }

    ResourceRequest<?>[] lookupCommand(String name) {
        return this.commands.getOrDefault(name, new ResourceRequest[0]);
    }

    public String readString(Path path) {
        try {
            return Files.readString(path);
        }
        catch (IOException e) {
            throw new BuildException("Cannot read file: " + e.getMessage());
        }
    }

    public int hashCode() {
        return Objects.hash(this.projectDirectory, this.projectName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProject other = (AbstractProject)obj;
        return Objects.equals(this.projectDirectory, other.projectDirectory) && Objects.equals(this.projectName, other.projectName);
    }

    @Override
    public String toString() {
        Path relDir = this.rootProject().directory().relativize(this.directory());
        return "Project " + this.name() + (String)(relDir.toString().isBlank() ? "" : " (in " + String.valueOf(relDir) + ")");
    }
}

